# Deployment Guide for cPanel

## Permission Issues

If you encounter permission errors like:
```
PHP Warning: require(.../vendor/...): Failed to open stream: Permission denied
```

This is because files extracted on the cPanel server don't have the correct permissions for the web server to read them.

## Solution

After extracting the release package on your cPanel server, run the permission fix script:

### Option 1: Using cPanel File Manager Terminal

1. Navigate to your application root directory
2. Run:
   ```bash
   bash scripts/fix-permissions.sh
   ```

### Option 2: Using SSH (if available)

1. SSH into your cPanel server
2. Navigate to your application directory:
   ```bash
   cd /home/intouchsoftco/public_html/jco.intouchsoft.co.za
   ```
3. Run the script:
   ```bash
   bash scripts/fix-permissions.sh
   ```

### Option 3: Manual Permission Fix via cPanel File Manager

If you cannot run the script, manually set permissions:

1. Open cPanel File Manager
2. Navigate to your application root
3. Set permissions:
   - **Directories**: 755
   - **Files**: 644
   - **artisan**: 755 (executable)
   - **storage/** directory: 775 (recursive)
   - **bootstrap/cache/** directory: 775 (recursive)
   - **vendor/** directory: 755 for directories, 644 for files (recursive)

## What the Script Does

The `fix-permissions.sh` script:
- Sets all directories to 755 (readable and executable by owner/group, readable by others)
- Sets all files to 644 (readable/writable by owner, readable by others)
- Makes `artisan` executable (755)
- Ensures `storage` and `bootstrap/cache` are writable (775)
- Fixes vendor directory permissions recursively

## Application Encryption Key

The deployment script will automatically:
- Check if `.env` file exists (create from `.env.example` if needed)
- Generate an application encryption key if `APP_KEY` is not set

If you need to manually generate the key:
```bash
php artisan key:generate
```

**Important**: Make sure your `.env` file has the correct configuration for production:
- `APP_ENV=production`
- `APP_DEBUG=false`
- `APP_KEY=base64:...` (generated by key:generate)
- Database credentials
- Other service configurations

## Additional Troubleshooting

### Permission Issues

If permission issues persist:

1. **Check file ownership**: Files should be owned by your cPanel user. Contact your hosting provider if ownership is incorrect.

2. **Check PHP user**: PHP should run as your cPanel user. You can check this by creating a PHP file with:
   ```php
   <?php echo exec('whoami'); ?>
   ```

3. **Check .htaccess**: Ensure your `.htaccess` file doesn't restrict access to vendor files.

4. **Contact hosting provider**: If issues persist, your hosting provider may need to adjust server-level permissions.

### Encryption Key Issues

If you see "No application encryption key has been specified":

1. **Check .env file exists**: Ensure `.env` file is in the application root
2. **Check APP_KEY is set**: Open `.env` and verify `APP_KEY=base64:...` exists
3. **Generate key**: Run `php artisan key:generate --force`
4. **Check permissions**: Ensure `.env` has 664 permissions and is readable/writable by PHP
5. **Clear config cache**: Run `php artisan config:clear`

### Database Migration Errors

If you encounter migration errors like "Duplicate column name" or "Column already exists":

**Common causes:**
- Migration was partially run before
- Database schema is out of sync with migrations
- Migration file was updated after initial run

**Solutions:**

1. **Check migration status:**
   ```bash
   php artisan migrate:status
   ```

2. **If a migration is stuck:**
   - Check if the column/table actually exists in the database
   - If column exists but migration shows as pending, mark it as run:
     ```bash
     php artisan migrate --pretend  # See what would run
     ```

3. **Reset and re-run migrations (WARNING: This will delete all data):**
   ```bash
   php artisan migrate:fresh --seed
   ```

4. **For specific duplicate column errors:**
   - The migration has been updated to check if columns exist before adding them
   - If you still get errors, you may need to manually check your database schema

### .env File Permission Denied

If you see "Failed to open stream: Permission denied" when writing to `.env`:

**Quick Fix:**
```bash
bash scripts/fix-env-permissions.sh
```

**Manual Fix:**
```bash
# Set permissions
chmod 664 .env

# Check ownership (should be your cPanel user)
ls -la .env

# Fix ownership if needed (replace 'youruser' with your cPanel username)
chown youruser:youruser .env

# Then generate the key
php artisan key:generate --force
```

**Common causes:**
- File extracted with wrong ownership (owned by root or different user)
- File permissions too restrictive (needs 664, not 644)
- PHP running as different user than file owner

