import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../wayfinder'
/**
* @see routes/xero.php:24
* @route '/xero/sync/customers'
*/
export const customers = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: customers.url(options),
    method: 'post',
})

customers.definition = {
    methods: ["post"],
    url: '/xero/sync/customers',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:24
* @route '/xero/sync/customers'
*/
customers.url = (options?: RouteQueryOptions) => {
    return customers.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:24
* @route '/xero/sync/customers'
*/
customers.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: customers.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:24
* @route '/xero/sync/customers'
*/
const customersForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: customers.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:24
* @route '/xero/sync/customers'
*/
customersForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: customers.url(options),
    method: 'post',
})

customers.form = customersForm

/**
* @see routes/xero.php:43
* @route '/xero/sync/products'
*/
export const products = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: products.url(options),
    method: 'post',
})

products.definition = {
    methods: ["post"],
    url: '/xero/sync/products',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:43
* @route '/xero/sync/products'
*/
products.url = (options?: RouteQueryOptions) => {
    return products.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:43
* @route '/xero/sync/products'
*/
products.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: products.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:43
* @route '/xero/sync/products'
*/
const productsForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: products.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:43
* @route '/xero/sync/products'
*/
productsForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: products.url(options),
    method: 'post',
})

products.form = productsForm

/**
* @see routes/xero.php:62
* @route '/xero/sync/customers-from-xero'
*/
export const customersFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: customersFromXero.url(options),
    method: 'post',
})

customersFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/customers-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:62
* @route '/xero/sync/customers-from-xero'
*/
customersFromXero.url = (options?: RouteQueryOptions) => {
    return customersFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:62
* @route '/xero/sync/customers-from-xero'
*/
customersFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: customersFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:62
* @route '/xero/sync/customers-from-xero'
*/
const customersFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: customersFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:62
* @route '/xero/sync/customers-from-xero'
*/
customersFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: customersFromXero.url(options),
    method: 'post',
})

customersFromXero.form = customersFromXeroForm

/**
* @see routes/xero.php:82
* @route '/xero/sync/products-from-xero'
*/
export const productsFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: productsFromXero.url(options),
    method: 'post',
})

productsFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/products-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:82
* @route '/xero/sync/products-from-xero'
*/
productsFromXero.url = (options?: RouteQueryOptions) => {
    return productsFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:82
* @route '/xero/sync/products-from-xero'
*/
productsFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: productsFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:82
* @route '/xero/sync/products-from-xero'
*/
const productsFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: productsFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:82
* @route '/xero/sync/products-from-xero'
*/
productsFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: productsFromXero.url(options),
    method: 'post',
})

productsFromXero.form = productsFromXeroForm

/**
* @see routes/xero.php:102
* @route '/xero/sync/invoices'
*/
export const invoices = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: invoices.url(options),
    method: 'post',
})

invoices.definition = {
    methods: ["post"],
    url: '/xero/sync/invoices',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:102
* @route '/xero/sync/invoices'
*/
invoices.url = (options?: RouteQueryOptions) => {
    return invoices.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:102
* @route '/xero/sync/invoices'
*/
invoices.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: invoices.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:102
* @route '/xero/sync/invoices'
*/
const invoicesForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: invoices.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:102
* @route '/xero/sync/invoices'
*/
invoicesForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: invoices.url(options),
    method: 'post',
})

invoices.form = invoicesForm

/**
* @see routes/xero.php:122
* @route '/xero/sync/suppliers'
*/
export const suppliers = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: suppliers.url(options),
    method: 'post',
})

suppliers.definition = {
    methods: ["post"],
    url: '/xero/sync/suppliers',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:122
* @route '/xero/sync/suppliers'
*/
suppliers.url = (options?: RouteQueryOptions) => {
    return suppliers.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:122
* @route '/xero/sync/suppliers'
*/
suppliers.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: suppliers.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:122
* @route '/xero/sync/suppliers'
*/
const suppliersForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: suppliers.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:122
* @route '/xero/sync/suppliers'
*/
suppliersForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: suppliers.url(options),
    method: 'post',
})

suppliers.form = suppliersForm

/**
* @see routes/xero.php:141
* @route '/xero/sync/suppliers-from-xero'
*/
export const suppliersFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: suppliersFromXero.url(options),
    method: 'post',
})

suppliersFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/suppliers-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:141
* @route '/xero/sync/suppliers-from-xero'
*/
suppliersFromXero.url = (options?: RouteQueryOptions) => {
    return suppliersFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:141
* @route '/xero/sync/suppliers-from-xero'
*/
suppliersFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: suppliersFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:141
* @route '/xero/sync/suppliers-from-xero'
*/
const suppliersFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: suppliersFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:141
* @route '/xero/sync/suppliers-from-xero'
*/
suppliersFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: suppliersFromXero.url(options),
    method: 'post',
})

suppliersFromXero.form = suppliersFromXeroForm

/**
* @see routes/xero.php:161
* @route '/xero/sync/quotes'
*/
export const quotes = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: quotes.url(options),
    method: 'post',
})

quotes.definition = {
    methods: ["post"],
    url: '/xero/sync/quotes',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:161
* @route '/xero/sync/quotes'
*/
quotes.url = (options?: RouteQueryOptions) => {
    return quotes.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:161
* @route '/xero/sync/quotes'
*/
quotes.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: quotes.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:161
* @route '/xero/sync/quotes'
*/
const quotesForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: quotes.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:161
* @route '/xero/sync/quotes'
*/
quotesForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: quotes.url(options),
    method: 'post',
})

quotes.form = quotesForm

/**
* @see routes/xero.php:180
* @route '/xero/sync/quotes-from-xero'
*/
export const quotesFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: quotesFromXero.url(options),
    method: 'post',
})

quotesFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/quotes-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:180
* @route '/xero/sync/quotes-from-xero'
*/
quotesFromXero.url = (options?: RouteQueryOptions) => {
    return quotesFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:180
* @route '/xero/sync/quotes-from-xero'
*/
quotesFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: quotesFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:180
* @route '/xero/sync/quotes-from-xero'
*/
const quotesFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: quotesFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:180
* @route '/xero/sync/quotes-from-xero'
*/
quotesFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: quotesFromXero.url(options),
    method: 'post',
})

quotesFromXero.form = quotesFromXeroForm

/**
* @see routes/xero.php:200
* @route '/xero/sync/tax-rates-from-xero'
*/
export const taxRatesFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: taxRatesFromXero.url(options),
    method: 'post',
})

taxRatesFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/tax-rates-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:200
* @route '/xero/sync/tax-rates-from-xero'
*/
taxRatesFromXero.url = (options?: RouteQueryOptions) => {
    return taxRatesFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:200
* @route '/xero/sync/tax-rates-from-xero'
*/
taxRatesFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: taxRatesFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:200
* @route '/xero/sync/tax-rates-from-xero'
*/
const taxRatesFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: taxRatesFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:200
* @route '/xero/sync/tax-rates-from-xero'
*/
taxRatesFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: taxRatesFromXero.url(options),
    method: 'post',
})

taxRatesFromXero.form = taxRatesFromXeroForm

/**
* @see routes/xero.php:220
* @route '/xero/sync/bank-accounts-from-xero'
*/
export const bankAccountsFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: bankAccountsFromXero.url(options),
    method: 'post',
})

bankAccountsFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/bank-accounts-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:220
* @route '/xero/sync/bank-accounts-from-xero'
*/
bankAccountsFromXero.url = (options?: RouteQueryOptions) => {
    return bankAccountsFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:220
* @route '/xero/sync/bank-accounts-from-xero'
*/
bankAccountsFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: bankAccountsFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:220
* @route '/xero/sync/bank-accounts-from-xero'
*/
const bankAccountsFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: bankAccountsFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:220
* @route '/xero/sync/bank-accounts-from-xero'
*/
bankAccountsFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: bankAccountsFromXero.url(options),
    method: 'post',
})

bankAccountsFromXero.form = bankAccountsFromXeroForm

/**
* @see routes/xero.php:240
* @route '/xero/sync/chart-of-accounts-from-xero'
*/
export const chartOfAccountsFromXero = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: chartOfAccountsFromXero.url(options),
    method: 'post',
})

chartOfAccountsFromXero.definition = {
    methods: ["post"],
    url: '/xero/sync/chart-of-accounts-from-xero',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:240
* @route '/xero/sync/chart-of-accounts-from-xero'
*/
chartOfAccountsFromXero.url = (options?: RouteQueryOptions) => {
    return chartOfAccountsFromXero.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:240
* @route '/xero/sync/chart-of-accounts-from-xero'
*/
chartOfAccountsFromXero.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: chartOfAccountsFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:240
* @route '/xero/sync/chart-of-accounts-from-xero'
*/
const chartOfAccountsFromXeroForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: chartOfAccountsFromXero.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:240
* @route '/xero/sync/chart-of-accounts-from-xero'
*/
chartOfAccountsFromXeroForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: chartOfAccountsFromXero.url(options),
    method: 'post',
})

chartOfAccountsFromXero.form = chartOfAccountsFromXeroForm

const sync = {
    customers: Object.assign(customers, customers),
    products: Object.assign(products, products),
    customersFromXero: Object.assign(customersFromXero, customersFromXero),
    productsFromXero: Object.assign(productsFromXero, productsFromXero),
    invoices: Object.assign(invoices, invoices),
    suppliers: Object.assign(suppliers, suppliers),
    suppliersFromXero: Object.assign(suppliersFromXero, suppliersFromXero),
    quotes: Object.assign(quotes, quotes),
    quotesFromXero: Object.assign(quotesFromXero, quotesFromXero),
    taxRatesFromXero: Object.assign(taxRatesFromXero, taxRatesFromXero),
    bankAccountsFromXero: Object.assign(bankAccountsFromXero, bankAccountsFromXero),
    chartOfAccountsFromXero: Object.assign(chartOfAccountsFromXero, chartOfAccountsFromXero),
}

export default sync