import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
import sync from './sync'
/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
export const authorize = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: authorize.url(options),
    method: 'get',
})

authorize.definition = {
    methods: ["get","head"],
    url: '/xero/authorize',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorize.url = (options?: RouteQueryOptions) => {
    return authorize.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorize.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: authorize.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorize.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: authorize.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
const authorizeForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: authorize.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorizeForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: authorize.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorizeForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: authorize.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

authorize.form = authorizeForm

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
export const callback = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: callback.url(options),
    method: 'get',
})

callback.definition = {
    methods: ["get","head"],
    url: '/xero/callback',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callback.url = (options?: RouteQueryOptions) => {
    return callback.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callback.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: callback.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callback.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: callback.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
const callbackForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: callback.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callbackForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: callback.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callbackForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: callback.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

callback.form = callbackForm

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
export const disconnect = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: disconnect.url(options),
    method: 'delete',
})

disconnect.definition = {
    methods: ["delete"],
    url: '/xero/disconnect',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
disconnect.url = (options?: RouteQueryOptions) => {
    return disconnect.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
disconnect.delete = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: disconnect.url(options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
const disconnectForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: disconnect.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
disconnectForm.delete = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: disconnect.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

disconnect.form = disconnectForm

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
export const switchCompany = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: switchCompany.url(options),
    method: 'post',
})

switchCompany.definition = {
    methods: ["post"],
    url: '/xero/switch-company',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
switchCompany.url = (options?: RouteQueryOptions) => {
    return switchCompany.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
switchCompany.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: switchCompany.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
const switchCompanyForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: switchCompany.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
switchCompanyForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: switchCompany.url(options),
    method: 'post',
})

switchCompany.form = switchCompanyForm

/**
* @see routes/xero.php:262
* @route '/xero/webhook'
*/
export const webhook = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: webhook.url(options),
    method: 'post',
})

webhook.definition = {
    methods: ["post"],
    url: '/xero/webhook',
} satisfies RouteDefinition<["post"]>

/**
* @see routes/xero.php:262
* @route '/xero/webhook'
*/
webhook.url = (options?: RouteQueryOptions) => {
    return webhook.definition.url + queryParams(options)
}

/**
* @see routes/xero.php:262
* @route '/xero/webhook'
*/
webhook.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: webhook.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:262
* @route '/xero/webhook'
*/
const webhookForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: webhook.url(options),
    method: 'post',
})

/**
* @see routes/xero.php:262
* @route '/xero/webhook'
*/
webhookForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: webhook.url(options),
    method: 'post',
})

webhook.form = webhookForm

const xero = {
    authorize: Object.assign(authorize, authorize),
    callback: Object.assign(callback, callback),
    disconnect: Object.assign(disconnect, disconnect),
    switchCompany: Object.assign(switchCompany, switchCompany),
    sync: Object.assign(sync, sync),
    webhook: Object.assign(webhook, webhook),
}

export default xero