import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/whatsapp-settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::index
* @see app/Http/Controllers/WhatsAppSettingsController.php:16
* @route '/administration/whatsapp-settings'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::store
* @see app/Http/Controllers/WhatsAppSettingsController.php:30
* @route '/administration/whatsapp-settings'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/administration/whatsapp-settings',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::store
* @see app/Http/Controllers/WhatsAppSettingsController.php:30
* @route '/administration/whatsapp-settings'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::store
* @see app/Http/Controllers/WhatsAppSettingsController.php:30
* @route '/administration/whatsapp-settings'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::store
* @see app/Http/Controllers/WhatsAppSettingsController.php:30
* @route '/administration/whatsapp-settings'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::store
* @see app/Http/Controllers/WhatsAppSettingsController.php:30
* @route '/administration/whatsapp-settings'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::update
* @see app/Http/Controllers/WhatsAppSettingsController.php:83
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
export const update = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/whatsapp-settings/{whatsAppSettings}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::update
* @see app/Http/Controllers/WhatsAppSettingsController.php:83
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
update.url = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { whatsAppSettings: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { whatsAppSettings: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            whatsAppSettings: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        whatsAppSettings: typeof args.whatsAppSettings === 'object'
        ? args.whatsAppSettings.id
        : args.whatsAppSettings,
    }

    return update.definition.url
            .replace('{whatsAppSettings}', parsedArgs.whatsAppSettings.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::update
* @see app/Http/Controllers/WhatsAppSettingsController.php:83
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
update.put = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::update
* @see app/Http/Controllers/WhatsAppSettingsController.php:83
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
const updateForm = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::update
* @see app/Http/Controllers/WhatsAppSettingsController.php:83
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
updateForm.put = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::destroy
* @see app/Http/Controllers/WhatsAppSettingsController.php:123
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
export const destroy = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/administration/whatsapp-settings/{whatsAppSettings}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::destroy
* @see app/Http/Controllers/WhatsAppSettingsController.php:123
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
destroy.url = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { whatsAppSettings: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { whatsAppSettings: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            whatsAppSettings: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        whatsAppSettings: typeof args.whatsAppSettings === 'object'
        ? args.whatsAppSettings.id
        : args.whatsAppSettings,
    }

    return destroy.definition.url
            .replace('{whatsAppSettings}', parsedArgs.whatsAppSettings.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::destroy
* @see app/Http/Controllers/WhatsAppSettingsController.php:123
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
destroy.delete = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::destroy
* @see app/Http/Controllers/WhatsAppSettingsController.php:123
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
const destroyForm = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\WhatsAppSettingsController::destroy
* @see app/Http/Controllers/WhatsAppSettingsController.php:123
* @route '/administration/whatsapp-settings/{whatsAppSettings}'
*/
destroyForm.delete = (args: { whatsAppSettings: string | number | { id: string | number } } | [whatsAppSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const whatsappSettings = {
    index: Object.assign(index, index),
    store: Object.assign(store, store),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default whatsappSettings