import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/stock-movements',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::index
* @see app/Http/Controllers/StockMovementsController.php:26
* @route '/stock-movements'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/stock-movements/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::create
* @see app/Http/Controllers/StockMovementsController.php:66
* @route '/stock-movements/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\StockMovementsController::store
* @see app/Http/Controllers/StockMovementsController.php:120
* @route '/stock-movements'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/stock-movements',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\StockMovementsController::store
* @see app/Http/Controllers/StockMovementsController.php:120
* @route '/stock-movements'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\StockMovementsController::store
* @see app/Http/Controllers/StockMovementsController.php:120
* @route '/stock-movements'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\StockMovementsController::store
* @see app/Http/Controllers/StockMovementsController.php:120
* @route '/stock-movements'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\StockMovementsController::store
* @see app/Http/Controllers/StockMovementsController.php:120
* @route '/stock-movements'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
export const show = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/stock-movements/{stockMovement}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
show.url = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { stockMovement: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { stockMovement: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            stockMovement: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        stockMovement: typeof args.stockMovement === 'object'
        ? args.stockMovement.id
        : args.stockMovement,
    }

    return show.definition.url
            .replace('{stockMovement}', parsedArgs.stockMovement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
show.get = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
show.head = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
const showForm = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
showForm.get = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\StockMovementsController::show
* @see app/Http/Controllers/StockMovementsController.php:203
* @route '/stock-movements/{stockMovement}'
*/
showForm.head = (args: { stockMovement: string | number | { id: string | number } } | [stockMovement: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

const stockMovements = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
}

export default stockMovements