import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/sms-settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::index
* @see app/Http/Controllers/SMSSettingsController.php:16
* @route '/administration/sms-settings'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SMSSettingsController::store
* @see app/Http/Controllers/SMSSettingsController.php:28
* @route '/administration/sms-settings'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/administration/sms-settings',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SMSSettingsController::store
* @see app/Http/Controllers/SMSSettingsController.php:28
* @route '/administration/sms-settings'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SMSSettingsController::store
* @see app/Http/Controllers/SMSSettingsController.php:28
* @route '/administration/sms-settings'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::store
* @see app/Http/Controllers/SMSSettingsController.php:28
* @route '/administration/sms-settings'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::store
* @see app/Http/Controllers/SMSSettingsController.php:28
* @route '/administration/sms-settings'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SMSSettingsController::update
* @see app/Http/Controllers/SMSSettingsController.php:58
* @route '/administration/sms-settings/{smsSettings}'
*/
export const update = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/sms-settings/{smsSettings}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\SMSSettingsController::update
* @see app/Http/Controllers/SMSSettingsController.php:58
* @route '/administration/sms-settings/{smsSettings}'
*/
update.url = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { smsSettings: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { smsSettings: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            smsSettings: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        smsSettings: typeof args.smsSettings === 'object'
        ? args.smsSettings.id
        : args.smsSettings,
    }

    return update.definition.url
            .replace('{smsSettings}', parsedArgs.smsSettings.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SMSSettingsController::update
* @see app/Http/Controllers/SMSSettingsController.php:58
* @route '/administration/sms-settings/{smsSettings}'
*/
update.put = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::update
* @see app/Http/Controllers/SMSSettingsController.php:58
* @route '/administration/sms-settings/{smsSettings}'
*/
const updateForm = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::update
* @see app/Http/Controllers/SMSSettingsController.php:58
* @route '/administration/sms-settings/{smsSettings}'
*/
updateForm.put = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SMSSettingsController::destroy
* @see app/Http/Controllers/SMSSettingsController.php:84
* @route '/administration/sms-settings/{smsSettings}'
*/
export const destroy = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/administration/sms-settings/{smsSettings}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SMSSettingsController::destroy
* @see app/Http/Controllers/SMSSettingsController.php:84
* @route '/administration/sms-settings/{smsSettings}'
*/
destroy.url = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { smsSettings: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { smsSettings: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            smsSettings: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        smsSettings: typeof args.smsSettings === 'object'
        ? args.smsSettings.id
        : args.smsSettings,
    }

    return destroy.definition.url
            .replace('{smsSettings}', parsedArgs.smsSettings.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SMSSettingsController::destroy
* @see app/Http/Controllers/SMSSettingsController.php:84
* @route '/administration/sms-settings/{smsSettings}'
*/
destroy.delete = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::destroy
* @see app/Http/Controllers/SMSSettingsController.php:84
* @route '/administration/sms-settings/{smsSettings}'
*/
const destroyForm = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SMSSettingsController::destroy
* @see app/Http/Controllers/SMSSettingsController.php:84
* @route '/administration/sms-settings/{smsSettings}'
*/
destroyForm.delete = (args: { smsSettings: string | number | { id: string | number } } | [smsSettings: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const smsSettings = {
    index: Object.assign(index, index),
    store: Object.assign(store, store),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default smsSettings