import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/purchase-orders',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::index
* @see app/Http/Controllers/PurchaseOrdersController.php:27
* @route '/purchase-orders'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/purchase-orders/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::create
* @see app/Http/Controllers/PurchaseOrdersController.php:64
* @route '/purchase-orders/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::store
* @see app/Http/Controllers/PurchaseOrdersController.php:94
* @route '/purchase-orders'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/purchase-orders',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::store
* @see app/Http/Controllers/PurchaseOrdersController.php:94
* @route '/purchase-orders'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::store
* @see app/Http/Controllers/PurchaseOrdersController.php:94
* @route '/purchase-orders'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::store
* @see app/Http/Controllers/PurchaseOrdersController.php:94
* @route '/purchase-orders'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::store
* @see app/Http/Controllers/PurchaseOrdersController.php:94
* @route '/purchase-orders'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
export const show = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/purchase-orders/{purchaseOrder}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
show.url = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { purchaseOrder: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { purchaseOrder: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            purchaseOrder: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        purchaseOrder: typeof args.purchaseOrder === 'object'
        ? args.purchaseOrder.id
        : args.purchaseOrder,
    }

    return show.definition.url
            .replace('{purchaseOrder}', parsedArgs.purchaseOrder.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
show.get = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
show.head = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
const showForm = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
showForm.get = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::show
* @see app/Http/Controllers/PurchaseOrdersController.php:149
* @route '/purchase-orders/{purchaseOrder}'
*/
showForm.head = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::updateStatus
* @see app/Http/Controllers/PurchaseOrdersController.php:199
* @route '/purchase-orders/{purchaseOrder}/status'
*/
export const updateStatus = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateStatus.url(args, options),
    method: 'put',
})

updateStatus.definition = {
    methods: ["put"],
    url: '/purchase-orders/{purchaseOrder}/status',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::updateStatus
* @see app/Http/Controllers/PurchaseOrdersController.php:199
* @route '/purchase-orders/{purchaseOrder}/status'
*/
updateStatus.url = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { purchaseOrder: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { purchaseOrder: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            purchaseOrder: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        purchaseOrder: typeof args.purchaseOrder === 'object'
        ? args.purchaseOrder.id
        : args.purchaseOrder,
    }

    return updateStatus.definition.url
            .replace('{purchaseOrder}', parsedArgs.purchaseOrder.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::updateStatus
* @see app/Http/Controllers/PurchaseOrdersController.php:199
* @route '/purchase-orders/{purchaseOrder}/status'
*/
updateStatus.put = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateStatus.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::updateStatus
* @see app/Http/Controllers/PurchaseOrdersController.php:199
* @route '/purchase-orders/{purchaseOrder}/status'
*/
const updateStatusForm = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::updateStatus
* @see app/Http/Controllers/PurchaseOrdersController.php:199
* @route '/purchase-orders/{purchaseOrder}/status'
*/
updateStatusForm.put = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateStatus.form = updateStatusForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::receiveItems
* @see app/Http/Controllers/PurchaseOrdersController.php:242
* @route '/purchase-orders/{purchaseOrder}/receive-items'
*/
export const receiveItems = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: receiveItems.url(args, options),
    method: 'post',
})

receiveItems.definition = {
    methods: ["post"],
    url: '/purchase-orders/{purchaseOrder}/receive-items',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::receiveItems
* @see app/Http/Controllers/PurchaseOrdersController.php:242
* @route '/purchase-orders/{purchaseOrder}/receive-items'
*/
receiveItems.url = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { purchaseOrder: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { purchaseOrder: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            purchaseOrder: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        purchaseOrder: typeof args.purchaseOrder === 'object'
        ? args.purchaseOrder.id
        : args.purchaseOrder,
    }

    return receiveItems.definition.url
            .replace('{purchaseOrder}', parsedArgs.purchaseOrder.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::receiveItems
* @see app/Http/Controllers/PurchaseOrdersController.php:242
* @route '/purchase-orders/{purchaseOrder}/receive-items'
*/
receiveItems.post = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: receiveItems.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::receiveItems
* @see app/Http/Controllers/PurchaseOrdersController.php:242
* @route '/purchase-orders/{purchaseOrder}/receive-items'
*/
const receiveItemsForm = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: receiveItems.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::receiveItems
* @see app/Http/Controllers/PurchaseOrdersController.php:242
* @route '/purchase-orders/{purchaseOrder}/receive-items'
*/
receiveItemsForm.post = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: receiveItems.url(args, options),
    method: 'post',
})

receiveItems.form = receiveItemsForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
export const downloadPdf = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: downloadPdf.url(args, options),
    method: 'get',
})

downloadPdf.definition = {
    methods: ["get","head"],
    url: '/purchase-orders/{purchaseOrder}/download-pdf',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
downloadPdf.url = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { purchaseOrder: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { purchaseOrder: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            purchaseOrder: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        purchaseOrder: typeof args.purchaseOrder === 'object'
        ? args.purchaseOrder.id
        : args.purchaseOrder,
    }

    return downloadPdf.definition.url
            .replace('{purchaseOrder}', parsedArgs.purchaseOrder.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
downloadPdf.get = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: downloadPdf.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
downloadPdf.head = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: downloadPdf.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
const downloadPdfForm = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: downloadPdf.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
downloadPdfForm.get = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: downloadPdf.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::downloadPdf
* @see app/Http/Controllers/PurchaseOrdersController.php:375
* @route '/purchase-orders/{purchaseOrder}/download-pdf'
*/
downloadPdfForm.head = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: downloadPdf.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

downloadPdf.form = downloadPdfForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::email
* @see app/Http/Controllers/PurchaseOrdersController.php:402
* @route '/purchase-orders/{purchaseOrder}/email'
*/
export const email = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: email.url(args, options),
    method: 'post',
})

email.definition = {
    methods: ["post"],
    url: '/purchase-orders/{purchaseOrder}/email',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::email
* @see app/Http/Controllers/PurchaseOrdersController.php:402
* @route '/purchase-orders/{purchaseOrder}/email'
*/
email.url = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { purchaseOrder: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { purchaseOrder: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            purchaseOrder: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        purchaseOrder: typeof args.purchaseOrder === 'object'
        ? args.purchaseOrder.id
        : args.purchaseOrder,
    }

    return email.definition.url
            .replace('{purchaseOrder}', parsedArgs.purchaseOrder.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::email
* @see app/Http/Controllers/PurchaseOrdersController.php:402
* @route '/purchase-orders/{purchaseOrder}/email'
*/
email.post = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: email.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::email
* @see app/Http/Controllers/PurchaseOrdersController.php:402
* @route '/purchase-orders/{purchaseOrder}/email'
*/
const emailForm = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: email.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::email
* @see app/Http/Controllers/PurchaseOrdersController.php:402
* @route '/purchase-orders/{purchaseOrder}/email'
*/
emailForm.post = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: email.url(args, options),
    method: 'post',
})

email.form = emailForm

/**
* @see \App\Http\Controllers\PurchaseOrdersController::destroy
* @see app/Http/Controllers/PurchaseOrdersController.php:354
* @route '/purchase-orders/{purchaseOrder}'
*/
export const destroy = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/purchase-orders/{purchaseOrder}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\PurchaseOrdersController::destroy
* @see app/Http/Controllers/PurchaseOrdersController.php:354
* @route '/purchase-orders/{purchaseOrder}'
*/
destroy.url = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { purchaseOrder: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { purchaseOrder: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            purchaseOrder: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        purchaseOrder: typeof args.purchaseOrder === 'object'
        ? args.purchaseOrder.id
        : args.purchaseOrder,
    }

    return destroy.definition.url
            .replace('{purchaseOrder}', parsedArgs.purchaseOrder.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PurchaseOrdersController::destroy
* @see app/Http/Controllers/PurchaseOrdersController.php:354
* @route '/purchase-orders/{purchaseOrder}'
*/
destroy.delete = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::destroy
* @see app/Http/Controllers/PurchaseOrdersController.php:354
* @route '/purchase-orders/{purchaseOrder}'
*/
const destroyForm = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\PurchaseOrdersController::destroy
* @see app/Http/Controllers/PurchaseOrdersController.php:354
* @route '/purchase-orders/{purchaseOrder}'
*/
destroyForm.delete = (args: { purchaseOrder: string | number | { id: string | number } } | [purchaseOrder: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const purchaseOrders = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    updateStatus: Object.assign(updateStatus, updateStatus),
    receiveItems: Object.assign(receiveItems, receiveItems),
    downloadPdf: Object.assign(downloadPdf, downloadPdf),
    email: Object.assign(email, email),
    destroy: Object.assign(destroy, destroy),
}

export default purchaseOrders