import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
export const index = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/products/{product}/batches',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
index.url = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { product: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { product: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            product: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
    }

    return index.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
index.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
index.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
const indexForm = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
indexForm.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::index
* @see app/Http/Controllers/ProductBatchController.php:17
* @route '/products/{product}/batches'
*/
indexForm.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
export const create = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/products/{product}/batches/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
create.url = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { product: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { product: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            product: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
    }

    return create.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
create.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
create.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
const createForm = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
createForm.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::create
* @see app/Http/Controllers/ProductBatchController.php:39
* @route '/products/{product}/batches/create'
*/
createForm.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\ProductBatchController::store
* @see app/Http/Controllers/ProductBatchController.php:55
* @route '/products/{product}/batches'
*/
export const store = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/products/{product}/batches',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ProductBatchController::store
* @see app/Http/Controllers/ProductBatchController.php:55
* @route '/products/{product}/batches'
*/
store.url = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { product: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { product: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            product: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
    }

    return store.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::store
* @see app/Http/Controllers/ProductBatchController.php:55
* @route '/products/{product}/batches'
*/
store.post = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductBatchController::store
* @see app/Http/Controllers/ProductBatchController.php:55
* @route '/products/{product}/batches'
*/
const storeForm = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductBatchController::store
* @see app/Http/Controllers/ProductBatchController.php:55
* @route '/products/{product}/batches'
*/
storeForm.post = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
export const show = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/products/{product}/batches/{batch}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
show.url = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            batch: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        batch: typeof args.batch === 'object'
        ? args.batch.id
        : args.batch,
    }

    return show.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{batch}', parsedArgs.batch.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
show.get = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
show.head = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
const showForm = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
showForm.get = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::show
* @see app/Http/Controllers/ProductBatchController.php:84
* @route '/products/{product}/batches/{batch}'
*/
showForm.head = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
export const edit = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/products/{product}/batches/{batch}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
edit.url = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            batch: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        batch: typeof args.batch === 'object'
        ? args.batch.id
        : args.batch,
    }

    return edit.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{batch}', parsedArgs.batch.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
edit.get = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
edit.head = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
const editForm = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
editForm.get = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductBatchController::edit
* @see app/Http/Controllers/ProductBatchController.php:103
* @route '/products/{product}/batches/{batch}/edit'
*/
editForm.head = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\ProductBatchController::update
* @see app/Http/Controllers/ProductBatchController.php:120
* @route '/products/{product}/batches/{batch}'
*/
export const update = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/products/{product}/batches/{batch}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\ProductBatchController::update
* @see app/Http/Controllers/ProductBatchController.php:120
* @route '/products/{product}/batches/{batch}'
*/
update.url = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            batch: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        batch: typeof args.batch === 'object'
        ? args.batch.id
        : args.batch,
    }

    return update.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{batch}', parsedArgs.batch.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::update
* @see app/Http/Controllers/ProductBatchController.php:120
* @route '/products/{product}/batches/{batch}'
*/
update.put = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\ProductBatchController::update
* @see app/Http/Controllers/ProductBatchController.php:120
* @route '/products/{product}/batches/{batch}'
*/
const updateForm = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductBatchController::update
* @see app/Http/Controllers/ProductBatchController.php:120
* @route '/products/{product}/batches/{batch}'
*/
updateForm.put = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\ProductBatchController::destroy
* @see app/Http/Controllers/ProductBatchController.php:146
* @route '/products/{product}/batches/{batch}'
*/
export const destroy = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/products/{product}/batches/{batch}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\ProductBatchController::destroy
* @see app/Http/Controllers/ProductBatchController.php:146
* @route '/products/{product}/batches/{batch}'
*/
destroy.url = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            batch: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        batch: typeof args.batch === 'object'
        ? args.batch.id
        : args.batch,
    }

    return destroy.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{batch}', parsedArgs.batch.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductBatchController::destroy
* @see app/Http/Controllers/ProductBatchController.php:146
* @route '/products/{product}/batches/{batch}'
*/
destroy.delete = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\ProductBatchController::destroy
* @see app/Http/Controllers/ProductBatchController.php:146
* @route '/products/{product}/batches/{batch}'
*/
const destroyForm = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductBatchController::destroy
* @see app/Http/Controllers/ProductBatchController.php:146
* @route '/products/{product}/batches/{batch}'
*/
destroyForm.delete = (args: { product: string | number | { id: string | number }, batch: string | number | { id: string | number } } | [product: string | number | { id: string | number }, batch: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const batches = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default batches