import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\TimeEntryController::convert
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
export const convert = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convert.url(args, options),
    method: 'post',
})

convert.definition = {
    methods: ["post"],
    url: '/jobcards/{jobcard}/time-entries/convert',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::convert
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
convert.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return convert.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::convert
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
convert.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convert.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::convert
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
const convertForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convert.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::convert
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
convertForm.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convert.url(args, options),
    method: 'post',
})

convert.form = convertForm

const timeEntries = {
    convert: Object.assign(convert, convert),
}

export default timeEntries