import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\AuditLogController::restore
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
export const restore = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: restore.url(args, options),
    method: 'post',
})

restore.definition = {
    methods: ["post"],
    url: '/audit-logs/versions/{modelVersion}/restore',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\AuditLogController::restore
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
restore.url = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { modelVersion: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { modelVersion: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            modelVersion: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        modelVersion: typeof args.modelVersion === 'object'
        ? args.modelVersion.id
        : args.modelVersion,
    }

    return restore.definition.url
            .replace('{modelVersion}', parsedArgs.modelVersion.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::restore
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
restore.post = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: restore.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AuditLogController::restore
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
const restoreForm = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: restore.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AuditLogController::restore
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
restoreForm.post = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: restore.url(args, options),
    method: 'post',
})

restore.form = restoreForm

const versions = {
    restore: Object.assign(restore, restore),
}

export default versions