import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/xero-settings',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
update.put = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
updateForm.put = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

const xeroSettings = {
    update: Object.assign(update, update),
}

export default xeroSettings