import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/tax-rates',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::index
* @see app/Http/Controllers/Administration/TaxRateController.php:17
* @route '/administration/tax-rates'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/administration/tax-rates/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::create
* @see app/Http/Controllers/Administration/TaxRateController.php:32
* @route '/administration/tax-rates/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\Administration\TaxRateController::store
* @see app/Http/Controllers/Administration/TaxRateController.php:40
* @route '/administration/tax-rates'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/administration/tax-rates',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::store
* @see app/Http/Controllers/Administration/TaxRateController.php:40
* @route '/administration/tax-rates'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::store
* @see app/Http/Controllers/Administration/TaxRateController.php:40
* @route '/administration/tax-rates'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::store
* @see app/Http/Controllers/Administration/TaxRateController.php:40
* @route '/administration/tax-rates'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::store
* @see app/Http/Controllers/Administration/TaxRateController.php:40
* @route '/administration/tax-rates'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
export const show = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/administration/tax-rates/{taxRate}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
show.url = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { taxRate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { taxRate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            taxRate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        taxRate: typeof args.taxRate === 'object'
        ? args.taxRate.id
        : args.taxRate,
    }

    return show.definition.url
            .replace('{taxRate}', parsedArgs.taxRate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
show.get = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
show.head = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
const showForm = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
showForm.get = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::show
* @see app/Http/Controllers/Administration/TaxRateController.php:71
* @route '/administration/tax-rates/{taxRate}'
*/
showForm.head = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
export const edit = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/administration/tax-rates/{taxRate}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
edit.url = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { taxRate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { taxRate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            taxRate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        taxRate: typeof args.taxRate === 'object'
        ? args.taxRate.id
        : args.taxRate,
    }

    return edit.definition.url
            .replace('{taxRate}', parsedArgs.taxRate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
edit.get = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
edit.head = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
const editForm = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
editForm.get = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::edit
* @see app/Http/Controllers/Administration/TaxRateController.php:87
* @route '/administration/tax-rates/{taxRate}/edit'
*/
editForm.head = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\Administration\TaxRateController::update
* @see app/Http/Controllers/Administration/TaxRateController.php:103
* @route '/administration/tax-rates/{taxRate}'
*/
export const update = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/tax-rates/{taxRate}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::update
* @see app/Http/Controllers/Administration/TaxRateController.php:103
* @route '/administration/tax-rates/{taxRate}'
*/
update.url = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { taxRate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { taxRate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            taxRate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        taxRate: typeof args.taxRate === 'object'
        ? args.taxRate.id
        : args.taxRate,
    }

    return update.definition.url
            .replace('{taxRate}', parsedArgs.taxRate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::update
* @see app/Http/Controllers/Administration/TaxRateController.php:103
* @route '/administration/tax-rates/{taxRate}'
*/
update.put = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::update
* @see app/Http/Controllers/Administration/TaxRateController.php:103
* @route '/administration/tax-rates/{taxRate}'
*/
const updateForm = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::update
* @see app/Http/Controllers/Administration/TaxRateController.php:103
* @route '/administration/tax-rates/{taxRate}'
*/
updateForm.put = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Administration\TaxRateController::destroy
* @see app/Http/Controllers/Administration/TaxRateController.php:137
* @route '/administration/tax-rates/{taxRate}'
*/
export const destroy = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/administration/tax-rates/{taxRate}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Administration\TaxRateController::destroy
* @see app/Http/Controllers/Administration/TaxRateController.php:137
* @route '/administration/tax-rates/{taxRate}'
*/
destroy.url = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { taxRate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { taxRate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            taxRate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        taxRate: typeof args.taxRate === 'object'
        ? args.taxRate.id
        : args.taxRate,
    }

    return destroy.definition.url
            .replace('{taxRate}', parsedArgs.taxRate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\TaxRateController::destroy
* @see app/Http/Controllers/Administration/TaxRateController.php:137
* @route '/administration/tax-rates/{taxRate}'
*/
destroy.delete = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::destroy
* @see app/Http/Controllers/Administration/TaxRateController.php:137
* @route '/administration/tax-rates/{taxRate}'
*/
const destroyForm = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\TaxRateController::destroy
* @see app/Http/Controllers/Administration/TaxRateController.php:137
* @route '/administration/tax-rates/{taxRate}'
*/
destroyForm.delete = (args: { taxRate: string | number | { id: string | number } } | [taxRate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const taxRates = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default taxRates