import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/module-visibility',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
update.put = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
updateForm.put = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

const moduleVisibility = {
    update: Object.assign(update, update),
}

export default moduleVisibility