import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
import categories from './categories'
import moduleVisibility229a0a from './module-visibility'
import pdfTemplates from './pdf-templates'
import xeroSettings610994 from './xero-settings'
import taxRates from './tax-rates'
import chartOfAccounts from './chart-of-accounts'
import bankAccounts from './bank-accounts'
/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
export const upgradeDatabase = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upgradeDatabase.url(options),
    method: 'post',
})

upgradeDatabase.definition = {
    methods: ["post"],
    url: '/administration/upgrade-database',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
upgradeDatabase.url = (options?: RouteQueryOptions) => {
    return upgradeDatabase.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
upgradeDatabase.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upgradeDatabase.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
const upgradeDatabaseForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upgradeDatabase.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
upgradeDatabaseForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upgradeDatabase.url(options),
    method: 'post',
})

upgradeDatabase.form = upgradeDatabaseForm

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
export const moduleVisibility = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: moduleVisibility.url(options),
    method: 'get',
})

moduleVisibility.definition = {
    methods: ["get","head"],
    url: '/administration/module-visibility',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibility.url = (options?: RouteQueryOptions) => {
    return moduleVisibility.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibility.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: moduleVisibility.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibility.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: moduleVisibility.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
const moduleVisibilityForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: moduleVisibility.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibilityForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: moduleVisibility.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibilityForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: moduleVisibility.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

moduleVisibility.form = moduleVisibilityForm

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
export const xeroSettings = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: xeroSettings.url(options),
    method: 'get',
})

xeroSettings.definition = {
    methods: ["get","head"],
    url: '/administration/xero-settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
xeroSettings.url = (options?: RouteQueryOptions) => {
    return xeroSettings.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
xeroSettings.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: xeroSettings.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
xeroSettings.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: xeroSettings.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
const xeroSettingsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: xeroSettings.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
xeroSettingsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: xeroSettings.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::xeroSettings
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
xeroSettingsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: xeroSettings.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

xeroSettings.form = xeroSettingsForm

const administration = {
    categories: Object.assign(categories, categories),
    index: Object.assign(index, index),
    upgradeDatabase: Object.assign(upgradeDatabase, upgradeDatabase),
    moduleVisibility: Object.assign(moduleVisibility, moduleVisibility229a0a),
    pdfTemplates: Object.assign(pdfTemplates, pdfTemplates),
    xeroSettings: Object.assign(xeroSettings, xeroSettings610994),
    taxRates: Object.assign(taxRates, taxRates),
    chartOfAccounts: Object.assign(chartOfAccounts, chartOfAccounts),
    bankAccounts: Object.assign(bankAccounts, bankAccounts),
}

export default administration