import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
export const show = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/user/two-factor-secret-key',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
show.url = (options?: RouteQueryOptions) => {
    return show.definition.url + queryParams(options)
}

/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
show.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(options),
    method: 'get',
})

/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
show.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(options),
    method: 'head',
})

/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
const showForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(options),
    method: 'get',
})

/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
showForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(options),
    method: 'get',
})

/**
* @see \Laravel\Fortify\Http\Controllers\TwoFactorSecretKeyController::show
* @see vendor/laravel/fortify/src/Http/Controllers/TwoFactorSecretKeyController.php:18
* @route '/user/two-factor-secret-key'
*/
showForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

const TwoFactorSecretKeyController = { show }

export default TwoFactorSecretKeyController