import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/xero-settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::index
* @see app/Http/Controllers/XeroSettingsController.php:11
* @route '/administration/xero-settings'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/xero-settings',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
update.put = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::update
* @see app/Http/Controllers/XeroSettingsController.php:52
* @route '/administration/xero-settings'
*/
updateForm.put = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
export const authorize = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: authorize.url(options),
    method: 'get',
})

authorize.definition = {
    methods: ["get","head"],
    url: '/xero/authorize',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorize.url = (options?: RouteQueryOptions) => {
    return authorize.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorize.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: authorize.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorize.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: authorize.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
const authorizeForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: authorize.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorizeForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: authorize.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::authorize
* @see app/Http/Controllers/XeroSettingsController.php:103
* @route '/xero/authorize'
*/
authorizeForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: authorize.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

authorize.form = authorizeForm

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
export const callback = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: callback.url(options),
    method: 'get',
})

callback.definition = {
    methods: ["get","head"],
    url: '/xero/callback',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callback.url = (options?: RouteQueryOptions) => {
    return callback.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callback.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: callback.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callback.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: callback.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
const callbackForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: callback.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callbackForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: callback.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::callback
* @see app/Http/Controllers/XeroSettingsController.php:117
* @route '/xero/callback'
*/
callbackForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: callback.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

callback.form = callbackForm

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
export const disconnect = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: disconnect.url(options),
    method: 'delete',
})

disconnect.definition = {
    methods: ["delete"],
    url: '/xero/disconnect',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
disconnect.url = (options?: RouteQueryOptions) => {
    return disconnect.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
disconnect.delete = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: disconnect.url(options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
const disconnectForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: disconnect.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::disconnect
* @see app/Http/Controllers/XeroSettingsController.php:172
* @route '/xero/disconnect'
*/
disconnectForm.delete = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: disconnect.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

disconnect.form = disconnectForm

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
export const switchCompany = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: switchCompany.url(options),
    method: 'post',
})

switchCompany.definition = {
    methods: ["post"],
    url: '/xero/switch-company',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
switchCompany.url = (options?: RouteQueryOptions) => {
    return switchCompany.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
switchCompany.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: switchCompany.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
const switchCompanyForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: switchCompany.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\XeroSettingsController::switchCompany
* @see app/Http/Controllers/XeroSettingsController.php:187
* @route '/xero/switch-company'
*/
switchCompanyForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: switchCompany.url(options),
    method: 'post',
})

switchCompany.form = switchCompanyForm

const XeroSettingsController = { index, update, authorize, callback, disconnect, switchCompany }

export default XeroSettingsController