import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/time-entries',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\TimeEntryController::index
* @see app/Http/Controllers/TimeEntryController.php:17
* @route '/time-entries'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\TimeEntryController::store
* @see app/Http/Controllers/TimeEntryController.php:100
* @route '/time-entries'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/time-entries',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::store
* @see app/Http/Controllers/TimeEntryController.php:100
* @route '/time-entries'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::store
* @see app/Http/Controllers/TimeEntryController.php:100
* @route '/time-entries'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::store
* @see app/Http/Controllers/TimeEntryController.php:100
* @route '/time-entries'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::store
* @see app/Http/Controllers/TimeEntryController.php:100
* @route '/time-entries'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\TimeEntryController::update
* @see app/Http/Controllers/TimeEntryController.php:152
* @route '/time-entries/{timeEntry}'
*/
export const update = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/time-entries/{timeEntry}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\TimeEntryController::update
* @see app/Http/Controllers/TimeEntryController.php:152
* @route '/time-entries/{timeEntry}'
*/
update.url = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { timeEntry: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { timeEntry: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            timeEntry: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        timeEntry: typeof args.timeEntry === 'object'
        ? args.timeEntry.id
        : args.timeEntry,
    }

    return update.definition.url
            .replace('{timeEntry}', parsedArgs.timeEntry.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::update
* @see app/Http/Controllers/TimeEntryController.php:152
* @route '/time-entries/{timeEntry}'
*/
update.put = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\TimeEntryController::update
* @see app/Http/Controllers/TimeEntryController.php:152
* @route '/time-entries/{timeEntry}'
*/
const updateForm = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::update
* @see app/Http/Controllers/TimeEntryController.php:152
* @route '/time-entries/{timeEntry}'
*/
updateForm.put = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\TimeEntryController::destroy
* @see app/Http/Controllers/TimeEntryController.php:201
* @route '/time-entries/{timeEntry}'
*/
export const destroy = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/time-entries/{timeEntry}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\TimeEntryController::destroy
* @see app/Http/Controllers/TimeEntryController.php:201
* @route '/time-entries/{timeEntry}'
*/
destroy.url = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { timeEntry: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { timeEntry: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            timeEntry: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        timeEntry: typeof args.timeEntry === 'object'
        ? args.timeEntry.id
        : args.timeEntry,
    }

    return destroy.definition.url
            .replace('{timeEntry}', parsedArgs.timeEntry.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::destroy
* @see app/Http/Controllers/TimeEntryController.php:201
* @route '/time-entries/{timeEntry}'
*/
destroy.delete = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\TimeEntryController::destroy
* @see app/Http/Controllers/TimeEntryController.php:201
* @route '/time-entries/{timeEntry}'
*/
const destroyForm = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::destroy
* @see app/Http/Controllers/TimeEntryController.php:201
* @route '/time-entries/{timeEntry}'
*/
destroyForm.delete = (args: { timeEntry: string | number | { id: string | number } } | [timeEntry: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\TimeEntryController::startTimer
* @see app/Http/Controllers/TimeEntryController.php:211
* @route '/time-entries/start-timer'
*/
export const startTimer = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: startTimer.url(options),
    method: 'post',
})

startTimer.definition = {
    methods: ["post"],
    url: '/time-entries/start-timer',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::startTimer
* @see app/Http/Controllers/TimeEntryController.php:211
* @route '/time-entries/start-timer'
*/
startTimer.url = (options?: RouteQueryOptions) => {
    return startTimer.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::startTimer
* @see app/Http/Controllers/TimeEntryController.php:211
* @route '/time-entries/start-timer'
*/
startTimer.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: startTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::startTimer
* @see app/Http/Controllers/TimeEntryController.php:211
* @route '/time-entries/start-timer'
*/
const startTimerForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: startTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::startTimer
* @see app/Http/Controllers/TimeEntryController.php:211
* @route '/time-entries/start-timer'
*/
startTimerForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: startTimer.url(options),
    method: 'post',
})

startTimer.form = startTimerForm

/**
* @see \App\Http\Controllers\TimeEntryController::stopTimer
* @see app/Http/Controllers/TimeEntryController.php:247
* @route '/time-entries/stop-timer'
*/
export const stopTimer = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: stopTimer.url(options),
    method: 'post',
})

stopTimer.definition = {
    methods: ["post"],
    url: '/time-entries/stop-timer',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::stopTimer
* @see app/Http/Controllers/TimeEntryController.php:247
* @route '/time-entries/stop-timer'
*/
stopTimer.url = (options?: RouteQueryOptions) => {
    return stopTimer.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::stopTimer
* @see app/Http/Controllers/TimeEntryController.php:247
* @route '/time-entries/stop-timer'
*/
stopTimer.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: stopTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::stopTimer
* @see app/Http/Controllers/TimeEntryController.php:247
* @route '/time-entries/stop-timer'
*/
const stopTimerForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: stopTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::stopTimer
* @see app/Http/Controllers/TimeEntryController.php:247
* @route '/time-entries/stop-timer'
*/
stopTimerForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: stopTimer.url(options),
    method: 'post',
})

stopTimer.form = stopTimerForm

/**
* @see \App\Http\Controllers\TimeEntryController::pauseTimer
* @see app/Http/Controllers/TimeEntryController.php:267
* @route '/time-entries/pause-timer'
*/
export const pauseTimer = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: pauseTimer.url(options),
    method: 'post',
})

pauseTimer.definition = {
    methods: ["post"],
    url: '/time-entries/pause-timer',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::pauseTimer
* @see app/Http/Controllers/TimeEntryController.php:267
* @route '/time-entries/pause-timer'
*/
pauseTimer.url = (options?: RouteQueryOptions) => {
    return pauseTimer.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::pauseTimer
* @see app/Http/Controllers/TimeEntryController.php:267
* @route '/time-entries/pause-timer'
*/
pauseTimer.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: pauseTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::pauseTimer
* @see app/Http/Controllers/TimeEntryController.php:267
* @route '/time-entries/pause-timer'
*/
const pauseTimerForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: pauseTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::pauseTimer
* @see app/Http/Controllers/TimeEntryController.php:267
* @route '/time-entries/pause-timer'
*/
pauseTimerForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: pauseTimer.url(options),
    method: 'post',
})

pauseTimer.form = pauseTimerForm

/**
* @see \App\Http\Controllers\TimeEntryController::resumeTimer
* @see app/Http/Controllers/TimeEntryController.php:287
* @route '/time-entries/resume-timer'
*/
export const resumeTimer = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resumeTimer.url(options),
    method: 'post',
})

resumeTimer.definition = {
    methods: ["post"],
    url: '/time-entries/resume-timer',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::resumeTimer
* @see app/Http/Controllers/TimeEntryController.php:287
* @route '/time-entries/resume-timer'
*/
resumeTimer.url = (options?: RouteQueryOptions) => {
    return resumeTimer.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::resumeTimer
* @see app/Http/Controllers/TimeEntryController.php:287
* @route '/time-entries/resume-timer'
*/
resumeTimer.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resumeTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::resumeTimer
* @see app/Http/Controllers/TimeEntryController.php:287
* @route '/time-entries/resume-timer'
*/
const resumeTimerForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resumeTimer.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::resumeTimer
* @see app/Http/Controllers/TimeEntryController.php:287
* @route '/time-entries/resume-timer'
*/
resumeTimerForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resumeTimer.url(options),
    method: 'post',
})

resumeTimer.form = resumeTimerForm

/**
* @see \App\Http\Controllers\TimeEntryController::convertToLineItems
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
export const convertToLineItems = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToLineItems.url(args, options),
    method: 'post',
})

convertToLineItems.definition = {
    methods: ["post"],
    url: '/jobcards/{jobcard}/time-entries/convert',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\TimeEntryController::convertToLineItems
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
convertToLineItems.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return convertToLineItems.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\TimeEntryController::convertToLineItems
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
convertToLineItems.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToLineItems.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::convertToLineItems
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
const convertToLineItemsForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToLineItems.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\TimeEntryController::convertToLineItems
* @see app/Http/Controllers/TimeEntryController.php:310
* @route '/jobcards/{jobcard}/time-entries/convert'
*/
convertToLineItemsForm.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToLineItems.url(args, options),
    method: 'post',
})

convertToLineItems.form = convertToLineItemsForm

const TimeEntryController = { index, store, update, destroy, startTimer, stopTimer, pauseTimer, resumeTimer, convertToLineItems }

export default TimeEntryController