import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/quotes',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::index
* @see app/Http/Controllers/QuotesController.php:25
* @route '/quotes'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/quotes/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::create
* @see app/Http/Controllers/QuotesController.php:71
* @route '/quotes/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\QuotesController::store
* @see app/Http/Controllers/QuotesController.php:91
* @route '/quotes'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/quotes',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\QuotesController::store
* @see app/Http/Controllers/QuotesController.php:91
* @route '/quotes'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::store
* @see app/Http/Controllers/QuotesController.php:91
* @route '/quotes'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::store
* @see app/Http/Controllers/QuotesController.php:91
* @route '/quotes'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::store
* @see app/Http/Controllers/QuotesController.php:91
* @route '/quotes'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
export const show = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/quotes/{quote}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
show.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return show.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
show.get = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
show.head = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
const showForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
showForm.get = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::show
* @see app/Http/Controllers/QuotesController.php:169
* @route '/quotes/{quote}'
*/
showForm.head = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
export const edit = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/quotes/{quote}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
edit.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return edit.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
edit.get = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
edit.head = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
const editForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
editForm.get = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::edit
* @see app/Http/Controllers/QuotesController.php:203
* @route '/quotes/{quote}/edit'
*/
editForm.head = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
export const update = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/quotes/{quote}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
update.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return update.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
update.put = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
update.patch = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
const updateForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
updateForm.put = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::update
* @see app/Http/Controllers/QuotesController.php:225
* @route '/quotes/{quote}'
*/
updateForm.patch = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\QuotesController::destroy
* @see app/Http/Controllers/QuotesController.php:298
* @route '/quotes/{quote}'
*/
export const destroy = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/quotes/{quote}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\QuotesController::destroy
* @see app/Http/Controllers/QuotesController.php:298
* @route '/quotes/{quote}'
*/
destroy.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return destroy.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::destroy
* @see app/Http/Controllers/QuotesController.php:298
* @route '/quotes/{quote}'
*/
destroy.delete = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\QuotesController::destroy
* @see app/Http/Controllers/QuotesController.php:298
* @route '/quotes/{quote}'
*/
const destroyForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::destroy
* @see app/Http/Controllers/QuotesController.php:298
* @route '/quotes/{quote}'
*/
destroyForm.delete = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\QuotesController::convertToJobcard
* @see app/Http/Controllers/QuotesController.php:322
* @route '/quotes/{quote}/convert-to-jobcard'
*/
export const convertToJobcard = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToJobcard.url(args, options),
    method: 'post',
})

convertToJobcard.definition = {
    methods: ["post"],
    url: '/quotes/{quote}/convert-to-jobcard',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\QuotesController::convertToJobcard
* @see app/Http/Controllers/QuotesController.php:322
* @route '/quotes/{quote}/convert-to-jobcard'
*/
convertToJobcard.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return convertToJobcard.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::convertToJobcard
* @see app/Http/Controllers/QuotesController.php:322
* @route '/quotes/{quote}/convert-to-jobcard'
*/
convertToJobcard.post = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToJobcard.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::convertToJobcard
* @see app/Http/Controllers/QuotesController.php:322
* @route '/quotes/{quote}/convert-to-jobcard'
*/
const convertToJobcardForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToJobcard.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::convertToJobcard
* @see app/Http/Controllers/QuotesController.php:322
* @route '/quotes/{quote}/convert-to-jobcard'
*/
convertToJobcardForm.post = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToJobcard.url(args, options),
    method: 'post',
})

convertToJobcard.form = convertToJobcardForm

/**
* @see \App\Http\Controllers\QuotesController::convertToInvoice
* @see app/Http/Controllers/QuotesController.php:336
* @route '/quotes/{quote}/convert-to-invoice'
*/
export const convertToInvoice = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToInvoice.url(args, options),
    method: 'post',
})

convertToInvoice.definition = {
    methods: ["post"],
    url: '/quotes/{quote}/convert-to-invoice',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\QuotesController::convertToInvoice
* @see app/Http/Controllers/QuotesController.php:336
* @route '/quotes/{quote}/convert-to-invoice'
*/
convertToInvoice.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return convertToInvoice.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::convertToInvoice
* @see app/Http/Controllers/QuotesController.php:336
* @route '/quotes/{quote}/convert-to-invoice'
*/
convertToInvoice.post = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToInvoice.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::convertToInvoice
* @see app/Http/Controllers/QuotesController.php:336
* @route '/quotes/{quote}/convert-to-invoice'
*/
const convertToInvoiceForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToInvoice.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::convertToInvoice
* @see app/Http/Controllers/QuotesController.php:336
* @route '/quotes/{quote}/convert-to-invoice'
*/
convertToInvoiceForm.post = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToInvoice.url(args, options),
    method: 'post',
})

convertToInvoice.form = convertToInvoiceForm

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
export const downloadPDF = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: downloadPDF.url(args, options),
    method: 'get',
})

downloadPDF.definition = {
    methods: ["get","head"],
    url: '/quotes/{quote}/download-pdf',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
downloadPDF.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return downloadPDF.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
downloadPDF.get = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: downloadPDF.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
downloadPDF.head = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: downloadPDF.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
const downloadPDFForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: downloadPDF.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
downloadPDFForm.get = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: downloadPDF.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\QuotesController::downloadPDF
* @see app/Http/Controllers/QuotesController.php:372
* @route '/quotes/{quote}/download-pdf'
*/
downloadPDFForm.head = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: downloadPDF.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

downloadPDF.form = downloadPDFForm

/**
* @see \App\Http\Controllers\QuotesController::emailQuote
* @see app/Http/Controllers/QuotesController.php:398
* @route '/quotes/{quote}/email'
*/
export const emailQuote = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: emailQuote.url(args, options),
    method: 'post',
})

emailQuote.definition = {
    methods: ["post"],
    url: '/quotes/{quote}/email',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\QuotesController::emailQuote
* @see app/Http/Controllers/QuotesController.php:398
* @route '/quotes/{quote}/email'
*/
emailQuote.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return emailQuote.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::emailQuote
* @see app/Http/Controllers/QuotesController.php:398
* @route '/quotes/{quote}/email'
*/
emailQuote.post = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: emailQuote.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::emailQuote
* @see app/Http/Controllers/QuotesController.php:398
* @route '/quotes/{quote}/email'
*/
const emailQuoteForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: emailQuote.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::emailQuote
* @see app/Http/Controllers/QuotesController.php:398
* @route '/quotes/{quote}/email'
*/
emailQuoteForm.post = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: emailQuote.url(args, options),
    method: 'post',
})

emailQuote.form = emailQuoteForm

/**
* @see \App\Http\Controllers\QuotesController::updateStatus
* @see app/Http/Controllers/QuotesController.php:308
* @route '/quotes/{quote}/status'
*/
export const updateStatus = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: updateStatus.url(args, options),
    method: 'patch',
})

updateStatus.definition = {
    methods: ["patch"],
    url: '/quotes/{quote}/status',
} satisfies RouteDefinition<["patch"]>

/**
* @see \App\Http\Controllers\QuotesController::updateStatus
* @see app/Http/Controllers/QuotesController.php:308
* @route '/quotes/{quote}/status'
*/
updateStatus.url = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { quote: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { quote: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            quote: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        quote: typeof args.quote === 'object'
        ? args.quote.id
        : args.quote,
    }

    return updateStatus.definition.url
            .replace('{quote}', parsedArgs.quote.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotesController::updateStatus
* @see app/Http/Controllers/QuotesController.php:308
* @route '/quotes/{quote}/status'
*/
updateStatus.patch = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: updateStatus.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\QuotesController::updateStatus
* @see app/Http/Controllers/QuotesController.php:308
* @route '/quotes/{quote}/status'
*/
const updateStatusForm = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\QuotesController::updateStatus
* @see app/Http/Controllers/QuotesController.php:308
* @route '/quotes/{quote}/status'
*/
updateStatusForm.patch = (args: { quote: string | number | { id: string | number } } | [quote: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateStatus.form = updateStatusForm

const QuotesController = { index, create, store, show, edit, update, destroy, convertToJobcard, convertToInvoice, downloadPDF, emailQuote, updateStatus }

export default QuotesController