import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
export const index = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/products/{product}/serial-numbers',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
index.url = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { product: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { product: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            product: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
    }

    return index.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
index.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
index.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
const indexForm = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
indexForm.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::index
* @see app/Http/Controllers/ProductSerialNumberController.php:17
* @route '/products/{product}/serial-numbers'
*/
indexForm.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
export const create = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/products/{product}/serial-numbers/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
create.url = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { product: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { product: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            product: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
    }

    return create.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
create.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
create.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
const createForm = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
createForm.get = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::create
* @see app/Http/Controllers/ProductSerialNumberController.php:40
* @route '/products/{product}/serial-numbers/create'
*/
createForm.head = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\ProductSerialNumberController::store
* @see app/Http/Controllers/ProductSerialNumberController.php:59
* @route '/products/{product}/serial-numbers'
*/
export const store = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/products/{product}/serial-numbers',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ProductSerialNumberController::store
* @see app/Http/Controllers/ProductSerialNumberController.php:59
* @route '/products/{product}/serial-numbers'
*/
store.url = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { product: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { product: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            product: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
    }

    return store.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductSerialNumberController::store
* @see app/Http/Controllers/ProductSerialNumberController.php:59
* @route '/products/{product}/serial-numbers'
*/
store.post = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::store
* @see app/Http/Controllers/ProductSerialNumberController.php:59
* @route '/products/{product}/serial-numbers'
*/
const storeForm = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::store
* @see app/Http/Controllers/ProductSerialNumberController.php:59
* @route '/products/{product}/serial-numbers'
*/
storeForm.post = (args: { product: string | number | { id: string | number } } | [product: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
export const show = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/products/{product}/serial-numbers/{serialNumber}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
show.url = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            serialNumber: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        serialNumber: typeof args.serialNumber === 'object'
        ? args.serialNumber.id
        : args.serialNumber,
    }

    return show.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{serialNumber}', parsedArgs.serialNumber.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
show.get = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
show.head = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
const showForm = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
showForm.get = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::show
* @see app/Http/Controllers/ProductSerialNumberController.php:95
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
showForm.head = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\ProductSerialNumberController::update
* @see app/Http/Controllers/ProductSerialNumberController.php:114
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
export const update = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/products/{product}/serial-numbers/{serialNumber}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\ProductSerialNumberController::update
* @see app/Http/Controllers/ProductSerialNumberController.php:114
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
update.url = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            serialNumber: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        serialNumber: typeof args.serialNumber === 'object'
        ? args.serialNumber.id
        : args.serialNumber,
    }

    return update.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{serialNumber}', parsedArgs.serialNumber.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductSerialNumberController::update
* @see app/Http/Controllers/ProductSerialNumberController.php:114
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
update.put = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::update
* @see app/Http/Controllers/ProductSerialNumberController.php:114
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
const updateForm = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::update
* @see app/Http/Controllers/ProductSerialNumberController.php:114
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
updateForm.put = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\ProductSerialNumberController::destroy
* @see app/Http/Controllers/ProductSerialNumberController.php:137
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
export const destroy = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/products/{product}/serial-numbers/{serialNumber}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\ProductSerialNumberController::destroy
* @see app/Http/Controllers/ProductSerialNumberController.php:137
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
destroy.url = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            product: args[0],
            serialNumber: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        product: typeof args.product === 'object'
        ? args.product.id
        : args.product,
        serialNumber: typeof args.serialNumber === 'object'
        ? args.serialNumber.id
        : args.serialNumber,
    }

    return destroy.definition.url
            .replace('{product}', parsedArgs.product.toString())
            .replace('{serialNumber}', parsedArgs.serialNumber.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProductSerialNumberController::destroy
* @see app/Http/Controllers/ProductSerialNumberController.php:137
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
destroy.delete = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::destroy
* @see app/Http/Controllers/ProductSerialNumberController.php:137
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
const destroyForm = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProductSerialNumberController::destroy
* @see app/Http/Controllers/ProductSerialNumberController.php:137
* @route '/products/{product}/serial-numbers/{serialNumber}'
*/
destroyForm.delete = (args: { product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } } | [product: string | number | { id: string | number }, serialNumber: string | number | { id: string | number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const ProductSerialNumberController = { index, create, store, show, update, destroy }

export default ProductSerialNumberController