import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/jobcards',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::index
* @see app/Http/Controllers/JobcardController.php:26
* @route '/jobcards'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/jobcards/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::create
* @see app/Http/Controllers/JobcardController.php:72
* @route '/jobcards/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\JobcardController::store
* @see app/Http/Controllers/JobcardController.php:92
* @route '/jobcards'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/jobcards',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\JobcardController::store
* @see app/Http/Controllers/JobcardController.php:92
* @route '/jobcards'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::store
* @see app/Http/Controllers/JobcardController.php:92
* @route '/jobcards'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::store
* @see app/Http/Controllers/JobcardController.php:92
* @route '/jobcards'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::store
* @see app/Http/Controllers/JobcardController.php:92
* @route '/jobcards'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
export const show = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/jobcards/{jobcard}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
show.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return show.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
show.get = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
show.head = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
const showForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
showForm.get = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::show
* @see app/Http/Controllers/JobcardController.php:184
* @route '/jobcards/{jobcard}'
*/
showForm.head = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
export const edit = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/jobcards/{jobcard}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
edit.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return edit.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
edit.get = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
edit.head = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
const editForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
editForm.get = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::edit
* @see app/Http/Controllers/JobcardController.php:222
* @route '/jobcards/{jobcard}/edit'
*/
editForm.head = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\JobcardController::update
* @see app/Http/Controllers/JobcardController.php:250
* @route '/jobcards/{jobcard}'
*/
export const update = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/jobcards/{jobcard}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\JobcardController::update
* @see app/Http/Controllers/JobcardController.php:250
* @route '/jobcards/{jobcard}'
*/
update.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return update.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::update
* @see app/Http/Controllers/JobcardController.php:250
* @route '/jobcards/{jobcard}'
*/
update.put = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\JobcardController::update
* @see app/Http/Controllers/JobcardController.php:250
* @route '/jobcards/{jobcard}'
*/
const updateForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::update
* @see app/Http/Controllers/JobcardController.php:250
* @route '/jobcards/{jobcard}'
*/
updateForm.put = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\JobcardController::updateStatus
* @see app/Http/Controllers/JobcardController.php:325
* @route '/jobcards/{jobcard}/status'
*/
export const updateStatus = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: updateStatus.url(args, options),
    method: 'patch',
})

updateStatus.definition = {
    methods: ["patch"],
    url: '/jobcards/{jobcard}/status',
} satisfies RouteDefinition<["patch"]>

/**
* @see \App\Http\Controllers\JobcardController::updateStatus
* @see app/Http/Controllers/JobcardController.php:325
* @route '/jobcards/{jobcard}/status'
*/
updateStatus.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return updateStatus.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::updateStatus
* @see app/Http/Controllers/JobcardController.php:325
* @route '/jobcards/{jobcard}/status'
*/
updateStatus.patch = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: updateStatus.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\JobcardController::updateStatus
* @see app/Http/Controllers/JobcardController.php:325
* @route '/jobcards/{jobcard}/status'
*/
const updateStatusForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::updateStatus
* @see app/Http/Controllers/JobcardController.php:325
* @route '/jobcards/{jobcard}/status'
*/
updateStatusForm.patch = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateStatus.form = updateStatusForm

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
export const print = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: print.url(args, options),
    method: 'get',
})

print.definition = {
    methods: ["get","head"],
    url: '/jobcards/{jobcard}/print',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
print.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return print.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
print.get = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: print.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
print.head = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: print.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
const printForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: print.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
printForm.get = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: print.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobcardController::print
* @see app/Http/Controllers/JobcardController.php:389
* @route '/jobcards/{jobcard}/print'
*/
printForm.head = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: print.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

print.form = printForm

/**
* @see \App\Http\Controllers\JobcardController::email
* @see app/Http/Controllers/JobcardController.php:415
* @route '/jobcards/{jobcard}/email'
*/
export const email = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: email.url(args, options),
    method: 'post',
})

email.definition = {
    methods: ["post"],
    url: '/jobcards/{jobcard}/email',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\JobcardController::email
* @see app/Http/Controllers/JobcardController.php:415
* @route '/jobcards/{jobcard}/email'
*/
email.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return email.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::email
* @see app/Http/Controllers/JobcardController.php:415
* @route '/jobcards/{jobcard}/email'
*/
email.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: email.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::email
* @see app/Http/Controllers/JobcardController.php:415
* @route '/jobcards/{jobcard}/email'
*/
const emailForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: email.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::email
* @see app/Http/Controllers/JobcardController.php:415
* @route '/jobcards/{jobcard}/email'
*/
emailForm.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: email.url(args, options),
    method: 'post',
})

email.form = emailForm

/**
* @see \App\Http\Controllers\JobcardController::convertToInvoice
* @see app/Http/Controllers/JobcardController.php:517
* @route '/jobcards/{jobcard}/convert-to-invoice'
*/
export const convertToInvoice = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToInvoice.url(args, options),
    method: 'post',
})

convertToInvoice.definition = {
    methods: ["post"],
    url: '/jobcards/{jobcard}/convert-to-invoice',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\JobcardController::convertToInvoice
* @see app/Http/Controllers/JobcardController.php:517
* @route '/jobcards/{jobcard}/convert-to-invoice'
*/
convertToInvoice.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return convertToInvoice.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::convertToInvoice
* @see app/Http/Controllers/JobcardController.php:517
* @route '/jobcards/{jobcard}/convert-to-invoice'
*/
convertToInvoice.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: convertToInvoice.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::convertToInvoice
* @see app/Http/Controllers/JobcardController.php:517
* @route '/jobcards/{jobcard}/convert-to-invoice'
*/
const convertToInvoiceForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToInvoice.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::convertToInvoice
* @see app/Http/Controllers/JobcardController.php:517
* @route '/jobcards/{jobcard}/convert-to-invoice'
*/
convertToInvoiceForm.post = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: convertToInvoice.url(args, options),
    method: 'post',
})

convertToInvoice.form = convertToInvoiceForm

/**
* @see \App\Http\Controllers\JobcardController::destroy
* @see app/Http/Controllers/JobcardController.php:372
* @route '/jobcards/{jobcard}'
*/
export const destroy = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/jobcards/{jobcard}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\JobcardController::destroy
* @see app/Http/Controllers/JobcardController.php:372
* @route '/jobcards/{jobcard}'
*/
destroy.url = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { jobcard: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { jobcard: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            jobcard: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        jobcard: typeof args.jobcard === 'object'
        ? args.jobcard.id
        : args.jobcard,
    }

    return destroy.definition.url
            .replace('{jobcard}', parsedArgs.jobcard.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobcardController::destroy
* @see app/Http/Controllers/JobcardController.php:372
* @route '/jobcards/{jobcard}'
*/
destroy.delete = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\JobcardController::destroy
* @see app/Http/Controllers/JobcardController.php:372
* @route '/jobcards/{jobcard}'
*/
const destroyForm = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobcardController::destroy
* @see app/Http/Controllers/JobcardController.php:372
* @route '/jobcards/{jobcard}'
*/
destroyForm.delete = (args: { jobcard: string | number | { id: string | number } } | [jobcard: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const JobcardController = { index, create, store, show, edit, update, updateStatus, print, email, convertToInvoice, destroy }

export default JobcardController