import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
export const show = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/install',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
show.url = (options?: RouteQueryOptions) => {
    return show.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
show.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
show.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
const showForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
showForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallerController::show
* @see app/Http/Controllers/InstallerController.php:15
* @route '/install'
*/
showForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\InstallerController::install
* @see app/Http/Controllers/InstallerController.php:20
* @route '/install'
*/
export const install = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: install.url(options),
    method: 'post',
})

install.definition = {
    methods: ["post"],
    url: '/install',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\InstallerController::install
* @see app/Http/Controllers/InstallerController.php:20
* @route '/install'
*/
install.url = (options?: RouteQueryOptions) => {
    return install.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallerController::install
* @see app/Http/Controllers/InstallerController.php:20
* @route '/install'
*/
install.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: install.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\InstallerController::install
* @see app/Http/Controllers/InstallerController.php:20
* @route '/install'
*/
const installForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: install.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\InstallerController::install
* @see app/Http/Controllers/InstallerController.php:20
* @route '/install'
*/
installForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: install.url(options),
    method: 'post',
})

install.form = installForm

const InstallerController = { show, install }

export default InstallerController