import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/company-settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::index
* @see app/Http/Controllers/CompanySettingsController.php:16
* @route '/company-settings'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/company-settings/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::create
* @see app/Http/Controllers/CompanySettingsController.php:42
* @route '/company-settings/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\CompanySettingsController::store
* @see app/Http/Controllers/CompanySettingsController.php:47
* @route '/company-settings'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/company-settings',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::store
* @see app/Http/Controllers/CompanySettingsController.php:47
* @route '/company-settings'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::store
* @see app/Http/Controllers/CompanySettingsController.php:47
* @route '/company-settings'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::store
* @see app/Http/Controllers/CompanySettingsController.php:47
* @route '/company-settings'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::store
* @see app/Http/Controllers/CompanySettingsController.php:47
* @route '/company-settings'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
export const show = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/company-settings/{company}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
show.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return show.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
show.get = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
show.head = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
const showForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
showForm.get = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::show
* @see app/Http/Controllers/CompanySettingsController.php:100
* @route '/company-settings/{company}'
*/
showForm.head = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
export const edit = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/company-settings/{company}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
edit.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return edit.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
edit.get = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
edit.head = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
const editForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
editForm.get = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::edit
* @see app/Http/Controllers/CompanySettingsController.php:112
* @route '/company-settings/{company}/edit'
*/
editForm.head = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\CompanySettingsController::update
* @see app/Http/Controllers/CompanySettingsController.php:127
* @route '/company-settings/{company}'
*/
export const update = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/company-settings/{company}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::update
* @see app/Http/Controllers/CompanySettingsController.php:127
* @route '/company-settings/{company}'
*/
update.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return update.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::update
* @see app/Http/Controllers/CompanySettingsController.php:127
* @route '/company-settings/{company}'
*/
update.put = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::update
* @see app/Http/Controllers/CompanySettingsController.php:127
* @route '/company-settings/{company}'
*/
const updateForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::update
* @see app/Http/Controllers/CompanySettingsController.php:127
* @route '/company-settings/{company}'
*/
updateForm.put = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\CompanySettingsController::uploadLogo
* @see app/Http/Controllers/CompanySettingsController.php:281
* @route '/company-settings/{company}/upload-logo'
*/
export const uploadLogo = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadLogo.url(args, options),
    method: 'post',
})

uploadLogo.definition = {
    methods: ["post"],
    url: '/company-settings/{company}/upload-logo',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::uploadLogo
* @see app/Http/Controllers/CompanySettingsController.php:281
* @route '/company-settings/{company}/upload-logo'
*/
uploadLogo.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return uploadLogo.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::uploadLogo
* @see app/Http/Controllers/CompanySettingsController.php:281
* @route '/company-settings/{company}/upload-logo'
*/
uploadLogo.post = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadLogo.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::uploadLogo
* @see app/Http/Controllers/CompanySettingsController.php:281
* @route '/company-settings/{company}/upload-logo'
*/
const uploadLogoForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadLogo.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::uploadLogo
* @see app/Http/Controllers/CompanySettingsController.php:281
* @route '/company-settings/{company}/upload-logo'
*/
uploadLogoForm.post = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadLogo.url(args, options),
    method: 'post',
})

uploadLogo.form = uploadLogoForm

/**
* @see \App\Http\Controllers\CompanySettingsController::destroy
* @see app/Http/Controllers/CompanySettingsController.php:231
* @route '/company-settings/{company}'
*/
export const destroy = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/company-settings/{company}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::destroy
* @see app/Http/Controllers/CompanySettingsController.php:231
* @route '/company-settings/{company}'
*/
destroy.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return destroy.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::destroy
* @see app/Http/Controllers/CompanySettingsController.php:231
* @route '/company-settings/{company}'
*/
destroy.delete = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::destroy
* @see app/Http/Controllers/CompanySettingsController.php:231
* @route '/company-settings/{company}'
*/
const destroyForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::destroy
* @see app/Http/Controllers/CompanySettingsController.php:231
* @route '/company-settings/{company}'
*/
destroyForm.delete = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\CompanySettingsController::setDefault
* @see app/Http/Controllers/CompanySettingsController.php:254
* @route '/company-settings/{company}/set-default'
*/
export const setDefault = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: setDefault.url(args, options),
    method: 'post',
})

setDefault.definition = {
    methods: ["post"],
    url: '/company-settings/{company}/set-default',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::setDefault
* @see app/Http/Controllers/CompanySettingsController.php:254
* @route '/company-settings/{company}/set-default'
*/
setDefault.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return setDefault.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::setDefault
* @see app/Http/Controllers/CompanySettingsController.php:254
* @route '/company-settings/{company}/set-default'
*/
setDefault.post = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: setDefault.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::setDefault
* @see app/Http/Controllers/CompanySettingsController.php:254
* @route '/company-settings/{company}/set-default'
*/
const setDefaultForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: setDefault.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::setDefault
* @see app/Http/Controllers/CompanySettingsController.php:254
* @route '/company-settings/{company}/set-default'
*/
setDefaultForm.post = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: setDefault.url(args, options),
    method: 'post',
})

setDefault.form = setDefaultForm

/**
* @see \App\Http\Controllers\CompanySettingsController::switchMethod
* @see app/Http/Controllers/CompanySettingsController.php:261
* @route '/company-settings/{company}/switch'
*/
export const switchMethod = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: switchMethod.url(args, options),
    method: 'post',
})

switchMethod.definition = {
    methods: ["post"],
    url: '/company-settings/{company}/switch',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::switchMethod
* @see app/Http/Controllers/CompanySettingsController.php:261
* @route '/company-settings/{company}/switch'
*/
switchMethod.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return switchMethod.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::switchMethod
* @see app/Http/Controllers/CompanySettingsController.php:261
* @route '/company-settings/{company}/switch'
*/
switchMethod.post = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: switchMethod.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::switchMethod
* @see app/Http/Controllers/CompanySettingsController.php:261
* @route '/company-settings/{company}/switch'
*/
const switchMethodForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: switchMethod.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::switchMethod
* @see app/Http/Controllers/CompanySettingsController.php:261
* @route '/company-settings/{company}/switch'
*/
switchMethodForm.post = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: switchMethod.url(args, options),
    method: 'post',
})

switchMethod.form = switchMethodForm

/**
* @see \App\Http\Controllers\CompanySettingsController::updateReminderSettings
* @see app/Http/Controllers/CompanySettingsController.php:308
* @route '/company-settings/{company}/reminder-settings'
*/
export const updateReminderSettings = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateReminderSettings.url(args, options),
    method: 'put',
})

updateReminderSettings.definition = {
    methods: ["put"],
    url: '/company-settings/{company}/reminder-settings',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\CompanySettingsController::updateReminderSettings
* @see app/Http/Controllers/CompanySettingsController.php:308
* @route '/company-settings/{company}/reminder-settings'
*/
updateReminderSettings.url = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { company: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { company: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            company: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        company: typeof args.company === 'object'
        ? args.company.id
        : args.company,
    }

    return updateReminderSettings.definition.url
            .replace('{company}', parsedArgs.company.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CompanySettingsController::updateReminderSettings
* @see app/Http/Controllers/CompanySettingsController.php:308
* @route '/company-settings/{company}/reminder-settings'
*/
updateReminderSettings.put = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateReminderSettings.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::updateReminderSettings
* @see app/Http/Controllers/CompanySettingsController.php:308
* @route '/company-settings/{company}/reminder-settings'
*/
const updateReminderSettingsForm = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateReminderSettings.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\CompanySettingsController::updateReminderSettings
* @see app/Http/Controllers/CompanySettingsController.php:308
* @route '/company-settings/{company}/reminder-settings'
*/
updateReminderSettingsForm.put = (args: { company: string | number | { id: string | number } } | [company: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateReminderSettings.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateReminderSettings.form = updateReminderSettingsForm

const CompanySettingsController = { index, create, store, show, edit, update, uploadLogo, destroy, setDefault, switchMethod, updateReminderSettings, switch: switchMethod }

export default CompanySettingsController