import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/backups',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\BackupController::index
* @see app/Http/Controllers/BackupController.php:22
* @route '/backups'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\BackupController::store
* @see app/Http/Controllers/BackupController.php:48
* @route '/backups'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/backups',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\BackupController::store
* @see app/Http/Controllers/BackupController.php:48
* @route '/backups'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::store
* @see app/Http/Controllers/BackupController.php:48
* @route '/backups'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::store
* @see app/Http/Controllers/BackupController.php:48
* @route '/backups'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::store
* @see app/Http/Controllers/BackupController.php:48
* @route '/backups'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
export const download = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: download.url(args, options),
    method: 'get',
})

download.definition = {
    methods: ["get","head"],
    url: '/backups/{backup}/download',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
download.url = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { backup: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { backup: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            backup: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        backup: typeof args.backup === 'object'
        ? args.backup.id
        : args.backup,
    }

    return download.definition.url
            .replace('{backup}', parsedArgs.backup.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
download.get = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: download.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
download.head = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: download.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
const downloadForm = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: download.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
downloadForm.get = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: download.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\BackupController::download
* @see app/Http/Controllers/BackupController.php:73
* @route '/backups/{backup}/download'
*/
downloadForm.head = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: download.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

download.form = downloadForm

/**
* @see \App\Http\Controllers\BackupController::restore
* @see app/Http/Controllers/BackupController.php:96
* @route '/backups/{backup}/restore'
*/
export const restore = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: restore.url(args, options),
    method: 'post',
})

restore.definition = {
    methods: ["post"],
    url: '/backups/{backup}/restore',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\BackupController::restore
* @see app/Http/Controllers/BackupController.php:96
* @route '/backups/{backup}/restore'
*/
restore.url = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { backup: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { backup: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            backup: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        backup: typeof args.backup === 'object'
        ? args.backup.id
        : args.backup,
    }

    return restore.definition.url
            .replace('{backup}', parsedArgs.backup.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::restore
* @see app/Http/Controllers/BackupController.php:96
* @route '/backups/{backup}/restore'
*/
restore.post = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: restore.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::restore
* @see app/Http/Controllers/BackupController.php:96
* @route '/backups/{backup}/restore'
*/
const restoreForm = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: restore.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::restore
* @see app/Http/Controllers/BackupController.php:96
* @route '/backups/{backup}/restore'
*/
restoreForm.post = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: restore.url(args, options),
    method: 'post',
})

restore.form = restoreForm

/**
* @see \App\Http\Controllers\BackupController::destroy
* @see app/Http/Controllers/BackupController.php:132
* @route '/backups/{backup}'
*/
export const destroy = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/backups/{backup}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\BackupController::destroy
* @see app/Http/Controllers/BackupController.php:132
* @route '/backups/{backup}'
*/
destroy.url = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { backup: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { backup: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            backup: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        backup: typeof args.backup === 'object'
        ? args.backup.id
        : args.backup,
    }

    return destroy.definition.url
            .replace('{backup}', parsedArgs.backup.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::destroy
* @see app/Http/Controllers/BackupController.php:132
* @route '/backups/{backup}'
*/
destroy.delete = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\BackupController::destroy
* @see app/Http/Controllers/BackupController.php:132
* @route '/backups/{backup}'
*/
const destroyForm = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::destroy
* @see app/Http/Controllers/BackupController.php:132
* @route '/backups/{backup}'
*/
destroyForm.delete = (args: { backup: string | number | { id: string | number } } | [backup: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\BackupController::storeSchedule
* @see app/Http/Controllers/BackupController.php:148
* @route '/backups/schedules'
*/
export const storeSchedule = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storeSchedule.url(options),
    method: 'post',
})

storeSchedule.definition = {
    methods: ["post"],
    url: '/backups/schedules',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\BackupController::storeSchedule
* @see app/Http/Controllers/BackupController.php:148
* @route '/backups/schedules'
*/
storeSchedule.url = (options?: RouteQueryOptions) => {
    return storeSchedule.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::storeSchedule
* @see app/Http/Controllers/BackupController.php:148
* @route '/backups/schedules'
*/
storeSchedule.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storeSchedule.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::storeSchedule
* @see app/Http/Controllers/BackupController.php:148
* @route '/backups/schedules'
*/
const storeScheduleForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storeSchedule.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::storeSchedule
* @see app/Http/Controllers/BackupController.php:148
* @route '/backups/schedules'
*/
storeScheduleForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storeSchedule.url(options),
    method: 'post',
})

storeSchedule.form = storeScheduleForm

/**
* @see \App\Http\Controllers\BackupController::updateSchedule
* @see app/Http/Controllers/BackupController.php:182
* @route '/backups/schedules/{schedule}'
*/
export const updateSchedule = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateSchedule.url(args, options),
    method: 'put',
})

updateSchedule.definition = {
    methods: ["put"],
    url: '/backups/schedules/{schedule}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\BackupController::updateSchedule
* @see app/Http/Controllers/BackupController.php:182
* @route '/backups/schedules/{schedule}'
*/
updateSchedule.url = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { schedule: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { schedule: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            schedule: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        schedule: typeof args.schedule === 'object'
        ? args.schedule.id
        : args.schedule,
    }

    return updateSchedule.definition.url
            .replace('{schedule}', parsedArgs.schedule.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::updateSchedule
* @see app/Http/Controllers/BackupController.php:182
* @route '/backups/schedules/{schedule}'
*/
updateSchedule.put = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateSchedule.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\BackupController::updateSchedule
* @see app/Http/Controllers/BackupController.php:182
* @route '/backups/schedules/{schedule}'
*/
const updateScheduleForm = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateSchedule.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::updateSchedule
* @see app/Http/Controllers/BackupController.php:182
* @route '/backups/schedules/{schedule}'
*/
updateScheduleForm.put = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateSchedule.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateSchedule.form = updateScheduleForm

/**
* @see \App\Http\Controllers\BackupController::destroySchedule
* @see app/Http/Controllers/BackupController.php:216
* @route '/backups/schedules/{schedule}'
*/
export const destroySchedule = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroySchedule.url(args, options),
    method: 'delete',
})

destroySchedule.definition = {
    methods: ["delete"],
    url: '/backups/schedules/{schedule}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\BackupController::destroySchedule
* @see app/Http/Controllers/BackupController.php:216
* @route '/backups/schedules/{schedule}'
*/
destroySchedule.url = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { schedule: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { schedule: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            schedule: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        schedule: typeof args.schedule === 'object'
        ? args.schedule.id
        : args.schedule,
    }

    return destroySchedule.definition.url
            .replace('{schedule}', parsedArgs.schedule.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\BackupController::destroySchedule
* @see app/Http/Controllers/BackupController.php:216
* @route '/backups/schedules/{schedule}'
*/
destroySchedule.delete = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroySchedule.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\BackupController::destroySchedule
* @see app/Http/Controllers/BackupController.php:216
* @route '/backups/schedules/{schedule}'
*/
const destroyScheduleForm = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroySchedule.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\BackupController::destroySchedule
* @see app/Http/Controllers/BackupController.php:216
* @route '/backups/schedules/{schedule}'
*/
destroyScheduleForm.delete = (args: { schedule: string | number | { id: string | number } } | [schedule: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroySchedule.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroySchedule.form = destroyScheduleForm

const BackupController = { index, store, download, restore, destroy, storeSchedule, updateSchedule, destroySchedule }

export default BackupController