import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/audit-logs',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::index
* @see app/Http/Controllers/AuditLogController.php:24
* @route '/audit-logs'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
export const exportMethod = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: exportMethod.url(options),
    method: 'get',
})

exportMethod.definition = {
    methods: ["get","head"],
    url: '/audit-logs/export',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
exportMethod.url = (options?: RouteQueryOptions) => {
    return exportMethod.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
exportMethod.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: exportMethod.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
exportMethod.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: exportMethod.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
const exportMethodForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: exportMethod.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
exportMethodForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: exportMethod.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::exportMethod
* @see app/Http/Controllers/AuditLogController.php:178
* @route '/audit-logs/export'
*/
exportMethodForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: exportMethod.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

exportMethod.form = exportMethodForm

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
export const forModel = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: forModel.url(args, options),
    method: 'get',
})

forModel.definition = {
    methods: ["get","head"],
    url: '/audit-logs/model/{modelType}/{modelId}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
forModel.url = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            modelType: args[0],
            modelId: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        modelType: args.modelType,
        modelId: args.modelId,
    }

    return forModel.definition.url
            .replace('{modelType}', parsedArgs.modelType.toString())
            .replace('{modelId}', parsedArgs.modelId.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
forModel.get = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: forModel.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
forModel.head = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: forModel.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
const forModelForm = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: forModel.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
forModelForm.get = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: forModel.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::forModel
* @see app/Http/Controllers/AuditLogController.php:123
* @route '/audit-logs/model/{modelType}/{modelId}'
*/
forModelForm.head = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: forModel.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

forModel.form = forModelForm

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
export const show = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/audit-logs/{auditLog}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
show.url = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { auditLog: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { auditLog: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            auditLog: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        auditLog: typeof args.auditLog === 'object'
        ? args.auditLog.id
        : args.auditLog,
    }

    return show.definition.url
            .replace('{auditLog}', parsedArgs.auditLog.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
show.get = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
show.head = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
const showForm = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
showForm.get = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::show
* @see app/Http/Controllers/AuditLogController.php:140
* @route '/audit-logs/{auditLog}'
*/
showForm.head = (args: { auditLog: string | number | { id: string | number } } | [auditLog: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
export const versions = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: versions.url(args, options),
    method: 'get',
})

versions.definition = {
    methods: ["get","head"],
    url: '/audit-logs/model/{modelType}/{modelId}/versions',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
versions.url = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            modelType: args[0],
            modelId: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        modelType: args.modelType,
        modelId: args.modelId,
    }

    return versions.definition.url
            .replace('{modelType}', parsedArgs.modelType.toString())
            .replace('{modelId}', parsedArgs.modelId.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
versions.get = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: versions.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
versions.head = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: versions.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
const versionsForm = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: versions.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
versionsForm.get = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: versions.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AuditLogController::versions
* @see app/Http/Controllers/AuditLogController.php:152
* @route '/audit-logs/model/{modelType}/{modelId}/versions'
*/
versionsForm.head = (args: { modelType: string | number, modelId: string | number } | [modelType: string | number, modelId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: versions.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

versions.form = versionsForm

/**
* @see \App\Http\Controllers\AuditLogController::restoreVersion
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
export const restoreVersion = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: restoreVersion.url(args, options),
    method: 'post',
})

restoreVersion.definition = {
    methods: ["post"],
    url: '/audit-logs/versions/{modelVersion}/restore',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\AuditLogController::restoreVersion
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
restoreVersion.url = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { modelVersion: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { modelVersion: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            modelVersion: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        modelVersion: typeof args.modelVersion === 'object'
        ? args.modelVersion.id
        : args.modelVersion,
    }

    return restoreVersion.definition.url
            .replace('{modelVersion}', parsedArgs.modelVersion.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\AuditLogController::restoreVersion
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
restoreVersion.post = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: restoreVersion.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AuditLogController::restoreVersion
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
const restoreVersionForm = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: restoreVersion.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AuditLogController::restoreVersion
* @see app/Http/Controllers/AuditLogController.php:166
* @route '/audit-logs/versions/{modelVersion}/restore'
*/
restoreVersionForm.post = (args: { modelVersion: string | number | { id: string | number } } | [modelVersion: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: restoreVersion.url(args, options),
    method: 'post',
})

restoreVersion.form = restoreVersionForm

const AuditLogController = { index, exportMethod, forModel, show, versions, restoreVersion, export: exportMethod }

export default AuditLogController