import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::index
* @see app/Http/Controllers/AdministrationController.php:19
* @route '/administration'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
export const upgradeDatabase = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upgradeDatabase.url(options),
    method: 'post',
})

upgradeDatabase.definition = {
    methods: ["post"],
    url: '/administration/upgrade-database',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
upgradeDatabase.url = (options?: RouteQueryOptions) => {
    return upgradeDatabase.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
upgradeDatabase.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upgradeDatabase.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
const upgradeDatabaseForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upgradeDatabase.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AdministrationController::upgradeDatabase
* @see app/Http/Controllers/AdministrationController.php:37
* @route '/administration/upgrade-database'
*/
upgradeDatabaseForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upgradeDatabase.url(options),
    method: 'post',
})

upgradeDatabase.form = upgradeDatabaseForm

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
export const moduleVisibility = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: moduleVisibility.url(options),
    method: 'get',
})

moduleVisibility.definition = {
    methods: ["get","head"],
    url: '/administration/module-visibility',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibility.url = (options?: RouteQueryOptions) => {
    return moduleVisibility.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibility.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: moduleVisibility.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibility.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: moduleVisibility.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
const moduleVisibilityForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: moduleVisibility.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibilityForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: moduleVisibility.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\AdministrationController::moduleVisibility
* @see app/Http/Controllers/AdministrationController.php:62
* @route '/administration/module-visibility'
*/
moduleVisibilityForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: moduleVisibility.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

moduleVisibility.form = moduleVisibilityForm

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/module-visibility',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
update.put = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\AdministrationController::update
* @see app/Http/Controllers/AdministrationController.php:71
* @route '/administration/module-visibility'
*/
updateForm.put = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

const AdministrationController = { index, upgradeDatabase, moduleVisibility, update }

export default AdministrationController