import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/pdf-templates',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::index
* @see app/Http/Controllers/Administration/PdfTemplateController.php:19
* @route '/administration/pdf-templates'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/administration/pdf-templates/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::create
* @see app/Http/Controllers/Administration/PdfTemplateController.php:38
* @route '/administration/pdf-templates/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::store
* @see app/Http/Controllers/Administration/PdfTemplateController.php:52
* @route '/administration/pdf-templates'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/administration/pdf-templates',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::store
* @see app/Http/Controllers/Administration/PdfTemplateController.php:52
* @route '/administration/pdf-templates'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::store
* @see app/Http/Controllers/Administration/PdfTemplateController.php:52
* @route '/administration/pdf-templates'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::store
* @see app/Http/Controllers/Administration/PdfTemplateController.php:52
* @route '/administration/pdf-templates'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::store
* @see app/Http/Controllers/Administration/PdfTemplateController.php:52
* @route '/administration/pdf-templates'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
export const edit = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/administration/pdf-templates/{pdfTemplate}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
edit.url = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { pdfTemplate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { pdfTemplate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            pdfTemplate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        pdfTemplate: typeof args.pdfTemplate === 'object'
        ? args.pdfTemplate.id
        : args.pdfTemplate,
    }

    return edit.definition.url
            .replace('{pdfTemplate}', parsedArgs.pdfTemplate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
edit.get = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
edit.head = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
const editForm = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
editForm.get = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::edit
* @see app/Http/Controllers/Administration/PdfTemplateController.php:85
* @route '/administration/pdf-templates/{pdfTemplate}/edit'
*/
editForm.head = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::update
* @see app/Http/Controllers/Administration/PdfTemplateController.php:98
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
export const update = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/pdf-templates/{pdfTemplate}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::update
* @see app/Http/Controllers/Administration/PdfTemplateController.php:98
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
update.url = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { pdfTemplate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { pdfTemplate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            pdfTemplate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        pdfTemplate: typeof args.pdfTemplate === 'object'
        ? args.pdfTemplate.id
        : args.pdfTemplate,
    }

    return update.definition.url
            .replace('{pdfTemplate}', parsedArgs.pdfTemplate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::update
* @see app/Http/Controllers/Administration/PdfTemplateController.php:98
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
update.put = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::update
* @see app/Http/Controllers/Administration/PdfTemplateController.php:98
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
const updateForm = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::update
* @see app/Http/Controllers/Administration/PdfTemplateController.php:98
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
updateForm.put = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::destroy
* @see app/Http/Controllers/Administration/PdfTemplateController.php:134
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
export const destroy = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/administration/pdf-templates/{pdfTemplate}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::destroy
* @see app/Http/Controllers/Administration/PdfTemplateController.php:134
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
destroy.url = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { pdfTemplate: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { pdfTemplate: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            pdfTemplate: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        pdfTemplate: typeof args.pdfTemplate === 'object'
        ? args.pdfTemplate.id
        : args.pdfTemplate,
    }

    return destroy.definition.url
            .replace('{pdfTemplate}', parsedArgs.pdfTemplate.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::destroy
* @see app/Http/Controllers/Administration/PdfTemplateController.php:134
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
destroy.delete = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::destroy
* @see app/Http/Controllers/Administration/PdfTemplateController.php:134
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
const destroyForm = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::destroy
* @see app/Http/Controllers/Administration/PdfTemplateController.php:134
* @route '/administration/pdf-templates/{pdfTemplate}'
*/
destroyForm.delete = (args: { pdfTemplate: string | number | { id: string | number } } | [pdfTemplate: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::uploadImage
* @see app/Http/Controllers/Administration/PdfTemplateController.php:152
* @route '/administration/pdf-templates/upload-image'
*/
export const uploadImage = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadImage.url(options),
    method: 'post',
})

uploadImage.definition = {
    methods: ["post"],
    url: '/administration/pdf-templates/upload-image',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::uploadImage
* @see app/Http/Controllers/Administration/PdfTemplateController.php:152
* @route '/administration/pdf-templates/upload-image'
*/
uploadImage.url = (options?: RouteQueryOptions) => {
    return uploadImage.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::uploadImage
* @see app/Http/Controllers/Administration/PdfTemplateController.php:152
* @route '/administration/pdf-templates/upload-image'
*/
uploadImage.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadImage.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::uploadImage
* @see app/Http/Controllers/Administration/PdfTemplateController.php:152
* @route '/administration/pdf-templates/upload-image'
*/
const uploadImageForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadImage.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\PdfTemplateController::uploadImage
* @see app/Http/Controllers/Administration/PdfTemplateController.php:152
* @route '/administration/pdf-templates/upload-image'
*/
uploadImageForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadImage.url(options),
    method: 'post',
})

uploadImage.form = uploadImageForm

const PdfTemplateController = { index, create, store, edit, update, destroy, uploadImage }

export default PdfTemplateController