import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/chart-of-accounts',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::index
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:17
* @route '/administration/chart-of-accounts'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/administration/chart-of-accounts/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::create
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:33
* @route '/administration/chart-of-accounts/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::store
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:50
* @route '/administration/chart-of-accounts'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/administration/chart-of-accounts',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::store
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:50
* @route '/administration/chart-of-accounts'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::store
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:50
* @route '/administration/chart-of-accounts'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::store
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:50
* @route '/administration/chart-of-accounts'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::store
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:50
* @route '/administration/chart-of-accounts'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
export const show = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/administration/chart-of-accounts/{chartOfAccount}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
show.url = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { chartOfAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { chartOfAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            chartOfAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        chartOfAccount: typeof args.chartOfAccount === 'object'
        ? args.chartOfAccount.id
        : args.chartOfAccount,
    }

    return show.definition.url
            .replace('{chartOfAccount}', parsedArgs.chartOfAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
show.get = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
show.head = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
const showForm = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
showForm.get = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::show
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:74
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
showForm.head = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
export const edit = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/administration/chart-of-accounts/{chartOfAccount}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
edit.url = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { chartOfAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { chartOfAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            chartOfAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        chartOfAccount: typeof args.chartOfAccount === 'object'
        ? args.chartOfAccount.id
        : args.chartOfAccount,
    }

    return edit.definition.url
            .replace('{chartOfAccount}', parsedArgs.chartOfAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
edit.get = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
edit.head = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
const editForm = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
editForm.get = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::edit
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:92
* @route '/administration/chart-of-accounts/{chartOfAccount}/edit'
*/
editForm.head = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::update
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:116
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
export const update = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/chart-of-accounts/{chartOfAccount}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::update
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:116
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
update.url = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { chartOfAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { chartOfAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            chartOfAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        chartOfAccount: typeof args.chartOfAccount === 'object'
        ? args.chartOfAccount.id
        : args.chartOfAccount,
    }

    return update.definition.url
            .replace('{chartOfAccount}', parsedArgs.chartOfAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::update
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:116
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
update.put = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::update
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:116
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
const updateForm = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::update
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:116
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
updateForm.put = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::destroy
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:149
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
export const destroy = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/administration/chart-of-accounts/{chartOfAccount}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::destroy
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:149
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
destroy.url = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { chartOfAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { chartOfAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            chartOfAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        chartOfAccount: typeof args.chartOfAccount === 'object'
        ? args.chartOfAccount.id
        : args.chartOfAccount,
    }

    return destroy.definition.url
            .replace('{chartOfAccount}', parsedArgs.chartOfAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::destroy
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:149
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
destroy.delete = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::destroy
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:149
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
const destroyForm = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\ChartOfAccountController::destroy
* @see app/Http/Controllers/Administration/ChartOfAccountController.php:149
* @route '/administration/chart-of-accounts/{chartOfAccount}'
*/
destroyForm.delete = (args: { chartOfAccount: string | number | { id: string | number } } | [chartOfAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const ChartOfAccountController = { index, create, store, show, edit, update, destroy }

export default ChartOfAccountController