import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/administration/bank-accounts',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::index
* @see app/Http/Controllers/Administration/BankAccountController.php:17
* @route '/administration/bank-accounts'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/administration/bank-accounts/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::create
* @see app/Http/Controllers/Administration/BankAccountController.php:33
* @route '/administration/bank-accounts/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\Administration\BankAccountController::store
* @see app/Http/Controllers/Administration/BankAccountController.php:41
* @route '/administration/bank-accounts'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/administration/bank-accounts',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::store
* @see app/Http/Controllers/Administration/BankAccountController.php:41
* @route '/administration/bank-accounts'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::store
* @see app/Http/Controllers/Administration/BankAccountController.php:41
* @route '/administration/bank-accounts'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::store
* @see app/Http/Controllers/Administration/BankAccountController.php:41
* @route '/administration/bank-accounts'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::store
* @see app/Http/Controllers/Administration/BankAccountController.php:41
* @route '/administration/bank-accounts'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
export const show = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/administration/bank-accounts/{bankAccount}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
show.url = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { bankAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { bankAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            bankAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return show.definition.url
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
show.get = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
show.head = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
const showForm = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
showForm.get = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::show
* @see app/Http/Controllers/Administration/BankAccountController.php:76
* @route '/administration/bank-accounts/{bankAccount}'
*/
showForm.head = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
export const edit = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/administration/bank-accounts/{bankAccount}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
edit.url = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { bankAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { bankAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            bankAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return edit.definition.url
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
edit.get = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
edit.head = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
const editForm = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
editForm.get = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::edit
* @see app/Http/Controllers/Administration/BankAccountController.php:92
* @route '/administration/bank-accounts/{bankAccount}/edit'
*/
editForm.head = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\Administration\BankAccountController::update
* @see app/Http/Controllers/Administration/BankAccountController.php:108
* @route '/administration/bank-accounts/{bankAccount}'
*/
export const update = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/administration/bank-accounts/{bankAccount}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::update
* @see app/Http/Controllers/Administration/BankAccountController.php:108
* @route '/administration/bank-accounts/{bankAccount}'
*/
update.url = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { bankAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { bankAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            bankAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return update.definition.url
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::update
* @see app/Http/Controllers/Administration/BankAccountController.php:108
* @route '/administration/bank-accounts/{bankAccount}'
*/
update.put = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::update
* @see app/Http/Controllers/Administration/BankAccountController.php:108
* @route '/administration/bank-accounts/{bankAccount}'
*/
const updateForm = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::update
* @see app/Http/Controllers/Administration/BankAccountController.php:108
* @route '/administration/bank-accounts/{bankAccount}'
*/
updateForm.put = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Administration\BankAccountController::destroy
* @see app/Http/Controllers/Administration/BankAccountController.php:146
* @route '/administration/bank-accounts/{bankAccount}'
*/
export const destroy = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/administration/bank-accounts/{bankAccount}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Administration\BankAccountController::destroy
* @see app/Http/Controllers/Administration/BankAccountController.php:146
* @route '/administration/bank-accounts/{bankAccount}'
*/
destroy.url = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { bankAccount: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { bankAccount: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            bankAccount: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return destroy.definition.url
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Administration\BankAccountController::destroy
* @see app/Http/Controllers/Administration/BankAccountController.php:146
* @route '/administration/bank-accounts/{bankAccount}'
*/
destroy.delete = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::destroy
* @see app/Http/Controllers/Administration/BankAccountController.php:146
* @route '/administration/bank-accounts/{bankAccount}'
*/
const destroyForm = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Administration\BankAccountController::destroy
* @see app/Http/Controllers/Administration/BankAccountController.php:146
* @route '/administration/bank-accounts/{bankAccount}'
*/
destroyForm.delete = (args: { bankAccount: string | number | { id: string | number } } | [bankAccount: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const BankAccountController = { index, create, store, show, edit, update, destroy }

export default BankAccountController