<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ReminderLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'reminder_type',
        'channel',
        'remindable_type',
        'remindable_id',
        'recipient_email',
        'recipient_phone',
        'message_sent',
        'status',
        'error_message',
        'sent_at',
    ];

    protected $casts = [
        'sent_at' => 'datetime',
    ];

    /**
     * Get the company that owns this reminder log.
     */
    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * Get the parent remindable model (invoice, quote, etc.).
     */
    public function remindable(): MorphTo
    {
        return $this->morphTo();
    }
}
