## [v0.1.0] - 2025-10-02

### Added
- Initial public release of JobCardOnline.
- Laravel 12 backend with Fortify authentication and Inertia.js Vue 3 frontend.
- Core modules: Users, Groups & Permissions, Customers, Contacts, Products, Quotes, Invoices, Jobcards, Payments, Settings.
- Bulk SMS integration and Xero sync services.
- Vite-based build with SSR bundle.

### Notes
- Build assets are generated into `public/build` and SSR bundle into `bootstrap/ssr`.
- Package includes production Composer autoload (no dev dependencies).


## [v0.1.1] - 2025-10-03

## [v0.1.2] - 2025-10-03

### Fixed
- Xero settings migration: avoid duplicate foreign key creation on production upgrades.

### Notes
- Fresh installs and upgrades are now consistent for `xero_settings` constraints.

## [v0.1.3] - 2025-10-03

### Added
- Web-based installer at `/install` for no-SSH deployments.
- Version display in app footer (reads from package.json or git).
- Admin user seeder with configurable credentials via env vars.
- Fallback UserFactory for production environments without Faker.

### Fixed
- Dashboard null company access with safe fallback UI.
- File permission errors in production with improved error handling.

### Notes
- Installer configures .env, runs migrations/seeders, creates admin user.
- Version shows in footer: package.json version, git tag, or commit hash.

## [v0.1.4] - 2025-10-03

### Fixed
- Composer dependency conflicts resolved (removed doctrine/dbal).
- Production vendor directory now properly included in releases.
- Migration compatibility improved for production environments.

### Notes
- Release now includes complete vendor directory for production deployment.
- No SSH access required for installation via web installer.

## [v0.1.5] - 2025-10-03

### Fixed
- Optimized Composer autoload files for production.
- Complete Laravel framework files included in vendor directory.
- Resolved missing Laravel exception renderer files.

### Notes
- Release includes complete and optimized vendor directory.
- All Laravel framework dependencies properly included.
- Production deployment should work without missing file errors.

## [v0.1.6] - 2025-10-03

### Fixed
- Custom exception handler to bypass Laravel framework CSS file issues.
- Graceful error handling for missing Laravel framework assets.
- Minimal error page for production environments.

### Notes
- Resolves Laravel 12 framework CSS file missing errors.
- Custom error handler provides fallback for framework asset issues.
- Production deployment should work without CSS file errors.

## [v0.1.7] - 2025-10-03

### Fixed
- Comprehensive error handling for Laravel framework CSS file issues.
- Multiple error view templates (500, 503, minimal) for different scenarios.
- Enhanced exception handler with ViewException support.
- HTTP exception override for server errors.

### Notes
- Multiple layers of error handling to catch CSS file errors.
- Custom error views for all server error scenarios.
- Production deployment should handle all Laravel framework asset issues.

## [v0.1.8] - 2025-10-03

### Fixed
- Added missing Laravel framework CSS file to vendor directory.
- Direct fix for the specific CSS file that Laravel is looking for.
- Resolves the root cause of the file_get_contents error.

### Notes
- Includes the exact CSS file that Laravel framework expects.
- Direct solution to the missing styles.css file issue.
- Production deployment should work without CSS file errors.

## [v0.1.9] - 2025-10-03

### Fixed
- CSS file created at the exact path Laravel is looking for.
- Corrected the relative path structure for Laravel framework assets.
- Resolves the specific file_get_contents error path.

### Notes
- CSS file now exists at the exact path shown in the error message.
- Direct solution to the missing styles.css file at the correct location.
- Production deployment should work without CSS file path errors.

## [v0.2.0] - 2025-10-03

### Fixed
- Comprehensive error handling that bypasses Laravel framework renderer.
- Custom error views for all HTTP status codes (404, 500, 503).
- Enhanced exception handler with framework renderer override.
- Resolves Laravel framework CSS file issues at the source.

### Notes
- Complete bypass of Laravel framework exception renderer.
- Custom error views for all scenarios without external dependencies.
- Production deployment should work without any Laravel framework asset issues.

## [v0.2.1] - 2025-10-03

### Fixed
- Ensured vendor directory with Laravel framework CSS files is included in release.
- Verified CSS file exists at correct path in vendor directory.
- Release now includes complete vendor directory with all framework assets.

### Notes
- Vendor directory properly included in release zip.
- Laravel framework CSS files available for production deployment.
- Production deployment should work with complete vendor directory.

## [v0.2.2] - 2025-10-03

### Fixed
- Updated release script to force include vendor directory in production releases.
- Vendor directory now properly included despite being in .gitignore.
- Laravel framework CSS files confirmed to be included in release zip.

### Notes
- Release script now explicitly copies vendor directory for production releases.
- Complete vendor directory with all Laravel framework assets included.
- Production deployment should work with all required framework files.

### Fixed
- Migrations: ensured `company_id` columns and foreign keys are consistent across `customers`, `contacts`, and `xero_settings` with safe ordering.
- Hardened Xero settings migration to handle missing default company and ensure column existence before constraints.
- Added `doctrine/dbal` to support column changes in migrations.

### Notes
- No breaking schema changes; fresh migrate recommended for new deployments.

## [v0.2.3] - 2025-01-27

### Added
- Enhanced authentication UI with improved branding and visual design.
- Custom JobCardOnline logo component with gradient styling.
- Updated login page with modern card-based layout and improved UX.
- Enhanced auth layout with background patterns and professional styling.

### Fixed
- Improved visual consistency across authentication pages.
- Enhanced user experience with better form styling and interactions.

### Notes
- Updated authentication interface with modern design patterns.
- Improved branding consistency throughout the application.

